/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.tools;

import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.formpopup.ValidatorManager;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import java.util.List;

public class InLineFormHelper {
    private FormLayout form;
    private HorizontalLayout footer;
    private String libModifier;
    private Button.ClickListener saveListener;
    private PopupListener refreshListener;
    private ValidatorManager validatorManager = new ValidatorManager();

    public InLineFormHelper(String sectionName, String libModifier, PopupListener refreshListener, Button.ClickListener saveListener) {
        this.libModifier = libModifier;
        this.saveListener = saveListener;
        this.refreshListener = refreshListener;
        this.form = new FormLayout();
        this.form.setMargin(false);
        Label section = new Label(sectionName);
        section.addStyleName("h2");
        section.addStyleName("colored");
        this.form.addComponent((Component)section);
    }

    public void addIn(Layout layout) {
        this.footer = new HorizontalLayout();
        this.footer.setWidth("100%");
        this.form.addComponent((Component)this.footer);
        this.formInLectureMode(this.form);
        layout.addComponent((Component)this.form);
    }

    private void formInCancelSaveMode(final FormLayout form) {
        form.removeStyleName("light");
        for (Component c : form) {
            if (!(c instanceof AbstractField)) continue;
            AbstractField field = (AbstractField)c;
            field.setReadOnly(false);
        }
        this.footer.removeAllComponents();
        this.footer.setMargin(false);
        this.footer.setSpacing(true);
        Label l = new Label();
        this.footer.addComponent((Component)l);
        this.footer.setExpandRatio((Component)l, 1.0f);
        Button cancel = new Button("Annuler");
        cancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                InLineFormHelper.this.refreshListener.onPopupClose();
                InLineFormHelper.this.formInLectureMode(form);
            }
        });
        this.footer.addComponent((Component)cancel);
        Button save = new Button("Sauvegarder");
        save.addStyleName("primary");
        save.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                List<String> msg = InLineFormHelper.this.validatorManager.validate();
                if (msg.size() > 0) {
                    msg.add(0, "Merci de corriger les points suivants :");
                    MessagePopup.open(new MessagePopup("Notification", msg));
                    return;
                }
                InLineFormHelper.this.saveListener.buttonClick(null);
                InLineFormHelper.this.refreshListener.onPopupClose();
                InLineFormHelper.this.formInLectureMode(form);
            }
        });
        this.footer.addComponent((Component)save);
        this.footer.setComponentAlignment((Component)save, Alignment.MIDDLE_LEFT);
    }

    private void formInLectureMode(final FormLayout form) {
        form.addStyleName("light");
        for (Component c : form) {
            if (!(c instanceof AbstractField)) continue;
            AbstractField field = (AbstractField)c;
            field.setReadOnly(true);
        }
        this.footer.removeAllComponents();
        this.footer.setMargin(new MarginInfo(true, false, true, false));
        this.footer.setSpacing(true);
        Label l = new Label();
        this.footer.addComponent((Component)l);
        this.footer.setExpandRatio((Component)l, 1.0f);
        Button edit = new Button(this.libModifier, new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                InLineFormHelper.this.formInCancelSaveMode(form);
            }
        });
        this.footer.addComponent((Component)edit);
    }

    public FormLayout getForm() {
        return this.form;
    }

    public ValidatorManager getValidatorManager() {
        return this.validatorManager;
    }
}

