/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.widgets;

import com.vaadin.data.util.converter.Converter;
import java.util.Locale;

public class CurrencyTextFieldConverter
implements Converter {
    boolean allowNegativeNumber;

    public CurrencyTextFieldConverter() {
        this(false);
    }

    public CurrencyTextFieldConverter(boolean allowNegativeNumber) {
        this.allowNegativeNumber = allowNegativeNumber;
    }

    public Integer convertToModel(Object value, Class targetType, Locale locale) throws Converter.ConversionException {
        if (value == null) {
            return null;
        }
        Integer i = this.convertToCurrency((String)value);
        if (i == null) {
            throw new Converter.ConversionException("Valeur incorrecte : " + value);
        }
        return i;
    }

    public Object convertToPresentation(Object value, Class targetType, Locale locale) throws Converter.ConversionException {
        if (value == null) {
            return null;
        }
        return this.convertToString((Integer)value);
    }

    public String convertToString(Integer value) {
        int prix = value;
        if (prix < 0) {
            return "-" + this.convertToString(-value.intValue());
        }
        int leftPart = prix / 100;
        int rightPart = prix % 100;
        if (rightPart < 10) {
            return String.valueOf(leftPart) + ".0" + rightPart;
        }
        return String.valueOf(leftPart) + "." + rightPart;
    }

    public Class<Integer> getModelType() {
        return Integer.class;
    }

    public Class<String> getPresentationType() {
        return String.class;
    }

    public Integer convertToCurrency(String str) {
        str = str.trim();
        if ((str = str.replace(',', '.')).length() == 0) {
            return new Integer(0);
        }
        if (str.charAt(0) == '-' && this.allowNegativeNumber) {
            Integer a = this.convertToCurrency(str = str.substring(1));
            if (a == null) {
                return null;
            }
            return new Integer(-a.intValue());
        }
        if (str.matches("^[0-9]*")) {
            return new Integer(Integer.parseInt(str) * 100);
        }
        if (str.matches("^[0-9]*\\.") && str.length() >= 2) {
            str = str.substring(0, str.length() - 1);
            return new Integer(Integer.parseInt(str) * 100);
        }
        if (str.matches("^[0-9]*\\.[0-9]*") && str.length() >= 2) {
            String[] toks = str.split("\\.");
            String tok1 = toks[0];
            String tok2 = toks[1];
            int racine = 0;
            if (tok1.length() > 0) {
                racine = new Integer(Integer.parseInt(tok1) * 100);
            }
            if (tok2.length() == 1) {
                return new Integer(racine + Integer.parseInt(tok2) * 10);
            }
            if (tok2.length() == 2) {
                return new Integer(racine + Integer.parseInt(tok2));
            }
        }
        return null;
    }
}

