/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.advanced.supervision;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.DateUtils;
import fr.amapj.common.GenericUtils;
import fr.amapj.service.engine.objectstorage.ObjectStorageServiceProvider;
import fr.amapj.service.services.advanced.maintenance.MaintenanceService;
import fr.amapj.service.services.advanced.supervision.SupervisionService;
import fr.amapj.service.services.mailer.MailerCounter;
import fr.amapj.view.engine.infoservlet.MonitorInfo;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.template.BackOfficeLongView;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;

public class SupervisionView
extends BackOfficeLongView
implements View {
    private static final Logger logger = LogManager.getLogger();
    Label labelDateHeure;
    TextField textDateHeure;

    @Override
    public String getMainStyleName() {
        return "maintenance";
    }

    @Override
    public void enterIn(ViewChangeListener.ViewChangeEvent event) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        this.addLabel(this, "Supervision du syst\u00e8me", "titre");
        this.addLabel(this, "Date et heure courante :" + df.format(DateUtils.getDate()));
        this.addLabel(this, "Version de l'application : " + new MaintenanceService().getVersion());
        this.addLabel(this, "Nombre d'emails envoy\u00e9s aujourd'hui : " + MailerCounter.getNbMails());
        Panel diversPanel = new Panel("Outils d'admin - Experts uniquement !");
        diversPanel.addStyleName("action");
        diversPanel.setContent(this.getDiversPanel());
        this.addComponent((Component)diversPanel);
    }

    private Component getDiversPanel() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addEmptyLine(layout);
        this.addButtonForInfo(layout, "Informations g\u00e9n\u00e9rales", () -> this.displayInfoGenerales());
        this.addButtonForInfo(layout, "Top", () -> this.displayInfoTop());
        this.addButtonForInfo(layout, "Statistics S3 / Cache EhCache", () -> this.displayCacheInfo());
        this.addButtonForInfo(layout, "Threads dump", () -> this.displayThreadInfo());
        this.addButtonForInfo(layout, "Visualiser le nombre de loggers actifs", () -> this.displayLoggerActif());
        this.addButtonForInfo(layout, "Afficher le cache JPA dans toutes les bases", () -> new SupervisionService().dumpCacheForAllBases());
        Button b2 = new Button("Remise \u00e0 z\u00e9ro du cache JPA dans toutes les bases", (Button.ClickListener & Serializable)e -> this.handleResetAllDatabaseCache());
        layout.addComponent((Component)b2);
        this.addEmptyLine(layout);
        Button b3 = new Button("Appel du garbage collector", (Button.ClickListener & Serializable)e -> this.handleGarbageCollector());
        layout.addComponent((Component)b3);
        this.addEmptyLine(layout);
        this.addEmptyLine(layout);
        return layout;
    }

    private String displayInfoGenerales() {
        MonitorInfo info = MonitorInfo.calculateMonitorInfo(false);
        return info.toString();
    }

    private String displayInfoTop() {
        MonitorInfo info = MonitorInfo.calculateMonitorInfo(true);
        return info.toString();
    }

    private String displayCacheInfo() {
        return ObjectStorageServiceProvider.getStatistics();
    }

    private String displayThreadInfo() {
        String res = "";
        Map<Thread, StackTraceElement[]> stacks = Thread.getAllStackTraces();
        List ls = stacks.entrySet().stream().sorted(Comparator.comparing(e -> ((Thread)e.getKey()).getName())).collect(Collectors.toList());
        for (Map.Entry entry : ls) {
            StackTraceElement[] elts;
            Thread t = (Thread)entry.getKey();
            res = String.valueOf(res) + "======================= Thread " + t.getName() + " id=" + t.getId() + " isDeamon " + t.isDaemon() + "<br/><br/>";
            StackTraceElement[] stackTraceElementArray = elts = (StackTraceElement[])entry.getValue();
            int n = elts.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                res = String.valueOf(res) + "\tat " + ste + "<br/>";
                ++n2;
            }
            res = String.valueOf(res) + "<br/><br/>";
        }
        return res;
    }

    private String displayLoggerActif() {
        int nb = this.countLoggerActif();
        return "Le nombre de logger actif est :" + nb;
    }

    private int countLoggerActif() {
        org.apache.logging.log4j.core.Logger coreLogger = (org.apache.logging.log4j.core.Logger)logger;
        LoggerContext context = coreLogger.getContext();
        RoutingAppender appender = (RoutingAppender)context.getConfiguration().getAppender("Routing");
        return appender.getAppenders().size();
    }

    private void handleGarbageCollector() {
        System.gc();
        Notification.show((String)"Done!");
    }

    private void handleResetAllDatabaseCache() {
        new SupervisionService().resetAllDataBaseCache();
        Notification.show((String)"Done!");
    }

    private Label addLabel(VerticalLayout layout, String str, String stylename) {
        Label tf = new Label(str);
        if (stylename != null) {
            tf.addStyleName(stylename);
        }
        layout.addComponent((Component)tf);
        return tf;
    }

    private Label addLabel(VerticalLayout layout, String str) {
        return this.addLabel(layout, str, null);
    }

    private Label addEmptyLine(VerticalLayout layout) {
        Label tf = new Label("<br/>", ContentMode.HTML);
        tf.addStyleName("big");
        layout.addComponent((Component)tf);
        return tf;
    }

    private void addButtonForInfo(VerticalLayout layout, String titre, GenericUtils.StringAction stringAction) {
        Button b2 = new Button(titre, (Button.ClickListener & Serializable)e -> this.handleButtonForInfo(titre, stringAction));
        layout.addComponent((Component)b2);
        this.addEmptyLine(layout);
    }

    private void handleButtonForInfo(String titre, GenericUtils.StringAction stringAction) {
        String msg = stringAction.action();
        MessagePopup.open(new MessagePopup(titre, ContentMode.HTML, CorePopup.ColorStyle.GREEN, msg));
    }
}

