/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.advanced.tenantnotification;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.messagingcenter.miniproxy.core.ServiceNotAvailableException;
import fr.amapj.messagingcenter.miniproxy.model.notification.AttachedDocument;
import fr.amapj.messagingcenter.miniproxy.model.notification.NotificationTools;
import fr.amapj.messagingcenter.miniproxy.model.notification.TenantNotificationDTO;
import fr.amapj.service.services.advanced.tenantnotification.TenantNotificationService;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;

public class TenantNotificationPopup
extends CorePopup {
    private TenantNotificationDTO dto;

    public TenantNotificationPopup(Long idNotification) throws ServiceNotAvailableException {
        this.setWidth(70);
        this.setHeight("80%");
        this.dto = new TenantNotificationService().loadNotification(idNotification);
        this.popupTitle = "Message";
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addDefaultButton("OK", (Button.ClickListener & Serializable)e -> this.close());
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yy HH:mm");
        Label l2 = new Label(" " + formatter.format(this.dto.refDate), ContentMode.TEXT);
        contentLayout.addComponent((Component)l2);
        Label l0 = new Label(this.dto.title, ContentMode.TEXT);
        l0.setWidth("100%");
        Panel p1 = new Panel();
        p1.setContent((Component)l0);
        p1.addStyleName("bandeau-titremail");
        contentLayout.addComponent((Component)p1);
        contentLayout.addComponent((Component)new Label("<br/>", ContentMode.HTML));
        Label la = new Label(NotificationTools.byteToHtml((byte[])this.dto.content), ContentMode.HTML);
        contentLayout.addComponent((Component)la);
        contentLayout.addComponent((Component)new Label("<br/><br/>", ContentMode.HTML));
        if (this.dto.documents.size() > 0) {
            contentLayout.addComponent((Component)new Label("<b>Pi\u00e8ces jointes : <b>", ContentMode.HTML));
        }
        for (AttachedDocument attachedDocument : this.dto.documents) {
            Link link = this.createLink(attachedDocument);
            contentLayout.addComponent((Component)link);
        }
    }

    private Link createLink(AttachedDocument ad) {
        StreamResource streamResource = new StreamResource((StreamResource.StreamSource & Serializable)() -> new ByteArrayInputStream(attachedDocument.content), ad.name);
        streamResource.setCacheTime(0L);
        Link extractFile = new Link(ad.name, (Resource)streamResource);
        extractFile.setIcon((Resource)FontAwesome.DOWNLOAD);
        extractFile.setTargetName("_blank");
        return extractFile;
    }
}

