/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.appinstance;

import fr.amapj.service.services.appinstance.AppInstanceDTO;
import fr.amapj.service.services.appinstance.AppInstanceService;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.copypopup.CopyPopup;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.engine.popup.swicthpopup.SwitchPopup;
import fr.amapj.view.views.appinstance.AppInstanceEditorPart;
import fr.amapj.view.views.appinstance.PatchEditorPart;
import fr.amapj.view.views.appinstance.PopupCheckCoherenceModeleContrat;
import fr.amapj.view.views.appinstance.PopupConnectAppInstance;
import fr.amapj.view.views.appinstance.PopupEtatAppInstance;
import fr.amapj.view.views.appinstance.PopupSaisieMailBackup;
import fr.amapj.view.views.appinstance.PopupSaveAppInstance;
import fr.amapj.view.views.appinstance.PopupSqlAppInstance;
import fr.amapj.view.views.appinstance.PopupStateOnStartAppInstance;
import java.util.List;

public class AppInstanceListPart
extends StandardListPart<AppInstanceDTO> {
    public AppInstanceListPart() {
        super(AppInstanceDTO.class, true);
    }

    @Override
    protected String getTitle() {
        return "Liste des instances";
    }

    @Override
    protected void drawButton() {
        this.addButton("Cr\u00e9er une nouvelle instance", ButtonType.ALWAYS, e -> new AppInstanceEditorPart());
        this.addButton("Etat courant", ButtonType.EDIT_MODE, e -> this.handleStart());
        this.addButton("Etat au d\u00e9marrage", ButtonType.EDIT_MODE, e -> this.handleStateOnStart());
        this.addButton("Se connecter", ButtonType.EDIT_MODE, e -> this.handleConnect());
        this.addButton("Requete SQL", ButtonType.EDIT_MODE, e -> this.handleSql());
        this.addButton("Sauvegarder", ButtonType.EDIT_MODE, e -> this.handleSave());
        this.addButton("Supprimer", ButtonType.EDIT_MODE, e -> this.handleSupprimer());
        this.addButton("PATCH V042", ButtonType.ALWAYS, e -> new PatchEditorPart());
        this.addButton("Autre ...", ButtonType.ALWAYS, e -> this.handleAutre());
        this.addSearchField("Rechercher par nom");
    }

    @Override
    protected void drawTable() {
        this.addColumn("nomInstance", "Nom");
        this.addColumnDateTime("dateCreation", "Date de cr\u00e9ation");
        this.addColumn("state", "Etat courant");
        this.addColumn("stateOnStart", "Etat d\u00e9marrage");
        this.addColumn("nbUtilisateurs", "Nb utilisateurs");
        this.addColumn("nbMails", "Mails envoy\u00e9s");
    }

    @Override
    protected List<AppInstanceDTO> getLines() {
        return new AppInstanceService().getAllInstances(true);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nomInstance"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nomInstance"};
    }

    private CorePopup handleAutre() {
        SwitchPopup popup = new SwitchPopup("Autres actions sur les instances", 60);
        popup.addLine("Extraire les mails de tous les administrateurs", () -> new CopyPopup("Mails des administrateurs", () -> new AppInstanceService().getAllMails()));
        popup.addLine("Extraire les mails de tous les administrateurs + tresoriers + stats", () -> new CopyPopup("Mails admin + stats", () -> new AppInstanceService().getStatInfo()));
        popup.addLine("Extraire les schemas de toutes les bases", () -> new CopyPopup("Schemas des bases", () -> new AppInstanceService().getSchemaAllBases(false)));
        popup.addLine("Extraire la taille de toutes les bases", () -> new CopyPopup("Taille des bases", () -> new AppInstanceService().getSchemaAllBases(true)));
        popup.addLine("Verifier la coh\u00e9rence des modeles de contrats", () -> new PopupCheckCoherenceModeleContrat(this.getSelectedLines()));
        popup.addLine("Param\u00e9trer le mail d'envoi des backups", () -> new PopupSaisieMailBackup());
        return popup;
    }

    private CorePopup handleStart() {
        List<AppInstanceDTO> dtos = this.getSelectedLines();
        return new PopupEtatAppInstance(dtos);
    }

    private CorePopup handleStateOnStart() {
        List<AppInstanceDTO> dtos = this.getSelectedLines();
        return new PopupStateOnStartAppInstance(dtos);
    }

    private CorePopup handleConnect() {
        List dtos = this.getSelectedLines();
        if (dtos.size() == 1) {
            AppInstanceDTO dto = (AppInstanceDTO)dtos.get(0);
            return new PopupConnectAppInstance(dto);
        }
        return new MessagePopup("Notification", CorePopup.ColorStyle.RED, "Vous devez selectionner une et une seule instance");
    }

    private CorePopup handleSql() {
        List<AppInstanceDTO> dtos = this.getSelectedLines();
        return new PopupSqlAppInstance(dtos);
    }

    private CorePopup handleSave() {
        List<AppInstanceDTO> dtos = this.getSelectedLines();
        return new PopupSaveAppInstance(dtos);
    }

    protected CorePopup handleSupprimer() {
        List dtos = this.getSelectedLines();
        if (dtos.size() != 1) {
            return new MessagePopup("Notification", CorePopup.ColorStyle.RED, "Vous devez selectionner une et une seule instance");
        }
        AppInstanceDTO dto = (AppInstanceDTO)dtos.get(0);
        String text = "Etes vous s\u00fbr de vouloir supprimer l'instance " + dto.nomInstance + " ?";
        return new SuppressionPopup(text, dto.id, e -> new AppInstanceService().delete((Long)e));
    }
}

