/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.appinstance;

import com.vaadin.ui.Upload;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.BoundedByteArrayOutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class BackupImporter
implements Upload.Receiver {
    public BoundedByteArrayOutputStream baos;
    private String filename;

    public OutputStream receiveUpload(String filename, String mimeType) {
        this.filename = filename;
        this.baos = new BoundedByteArrayOutputStream(5000000, 20000000);
        return this.baos;
    }

    public String getNomInstance() {
        return this.filename.substring(0, this.filename.length() - 7);
    }

    public void extractFile(String destDir) {
        try {
            GZIPInputStream zipIn = new GZIPInputStream(this.baos.getInputStream());
            TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)zipIn);
            String shortName = this.filename.substring(0, this.filename.length() - 32);
            String extension = this.filename.substring(this.filename.length() - 32, this.filename.length() - 7);
            this.processEntry(tarIn, shortName, "properties", destDir, extension);
            this.processEntry(tarIn, shortName, "script", destDir, extension);
            tarIn.close();
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    private void processEntry(TarArchiveInputStream tarIn, String dbName, String suffix, String dirDest, String extension) throws IOException {
        ArchiveEntry entry = tarIn.getNextEntry();
        if (entry.isDirectory()) {
            throw new AmapjRuntimeException();
        }
        int bufferSize = 131072;
        byte[] data = new byte[bufferSize];
        if (!entry.getName().equals(String.valueOf(dbName) + "." + suffix)) {
            throw new AmapjRuntimeException("entryName = " + entry.getName());
        }
        if (entry.getName().indexOf("..") != -1 || entry.getName().indexOf(47) != -1 || entry.getName().indexOf(92) != -1) {
            throw new AmapjRuntimeException();
        }
        FileOutputStream fos = new FileOutputStream(String.valueOf(dirDest) + "/" + dbName + extension + "." + suffix, false);
        Throwable throwable = null;
        Object var12_12 = null;
        try (BufferedOutputStream dest = new BufferedOutputStream(fos, bufferSize);){
            int count;
            while ((count = tarIn.read(data, 0, bufferSize)) != -1) {
                dest.write(data, 0, count);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

