/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.archivage.contrat;

import fr.amapj.model.engine.IdentifiableUtil;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.views.archivage.contrat.PopupContratSuppression;
import fr.amapj.view.views.archivage.contrat.PopupRetourActif;
import fr.amapj.view.views.common.contrattelecharger.TelechargerContrat;
import fr.amapj.view.views.gestioncontrat.editorpart.GestionContratEditorPart;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.util.List;

public class ArchivageContratListPart
extends StandardListPart<ModeleContratSummaryDTO> {
    private List<Producteur> allowedProducteurs = new AccessManagementService().getAccessLivraisonProducteur(SessionManager.getUserRoles(), SessionManager.getUserId(), false);

    public ArchivageContratListPart() {
        super(ModeleContratSummaryDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des contrats archiv\u00e9s";
    }

    @Override
    protected void drawButton() {
        this.addButton("Cr\u00e9er \u00e0 partir de ...", ButtonType.EDIT_MODE, e -> new GestionContratEditorPart(e.id, this.allowedProducteurs));
        this.addButtonAction("Tester", ButtonType.EDIT_MODE, () -> this.handleTester());
        this.addButton("T\u00e9l\u00e9charger ...", ButtonType.EDIT_MODE, e -> TelechargerContrat.displayPopupTelechargerContrat(e.id, null));
        this.addButton("Changer l'\u00e9tat", ButtonType.EDIT_MODE, e -> new PopupRetourActif((ModeleContratSummaryDTO)e));
        this.addButton("Supprimer d\u00e9finitivement", ButtonType.EDIT_MODE, e -> new PopupContratSuppression((ModeleContratSummaryDTO)e));
        this.addSearchField("Rechercher par nom ou producteur");
    }

    @Override
    protected void drawTable() {
        this.addColumn("etat", "Etat");
        this.addColumn("nom", "Nom");
        this.addColumn("nomProducteur", "Producteur");
        this.addColumnDate("finInscription", "Fin inscription");
        this.addColumnDate("dateDebut", "Premi\u00e8re livraison");
        this.addColumnDate("dateFin", "Derni\u00e8re livraison");
        this.addColumn("nbLivraison", "Livraisons").center();
        this.addColumn("nbInscrits", "Contrats sign\u00e9s").center();
    }

    @Override
    protected List<ModeleContratSummaryDTO> getLines() {
        return new GestionContratService().getModeleContratInfo(EtatModeleContrat.ARCHIVE);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"dateFin"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom", "nomProducteur"};
    }

    private void handleTester() {
        ModeleContratSummaryDTO mcDto = (ModeleContratSummaryDTO)this.getSelectedLine();
        SaisieContrat.saisieContrat(mcDto.id, null, null, "Mode Test", SaisieContrat.ModeSaisie.FOR_TEST, this);
    }

    @Override
    protected boolean isEditAllowed() {
        ModeleContratSummaryDTO mcDto = (ModeleContratSummaryDTO)this.getSelectedLine();
        if (mcDto == null) {
            return false;
        }
        return IdentifiableUtil.contains(this.allowedProducteurs, mcDto.producteurId);
    }
}

