/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.archivage.gestion;

import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.template.BackOfficeLongView;
import fr.amapj.view.views.archivage.gestion.PopupArchivageContrat;
import fr.amapj.view.views.archivage.gestion.PopupArchivageProducteur;
import fr.amapj.view.views.archivage.gestion.PopupArchivageUtilisateur;
import fr.amapj.view.views.archivage.gestion.PopupSaisieParametresArchivage;
import fr.amapj.view.views.archivage.gestion.PopupSuppressionContrat;
import fr.amapj.view.views.archivage.gestion.PopupSuppressionPeriodeCotisation;
import fr.amapj.view.views.archivage.gestion.PopupSuppressionPeriodePermanence;
import fr.amapj.view.views.archivage.gestion.PopupSuppressionProducteur;
import fr.amapj.view.views.archivage.gestion.PopupSuppressionUtilisateur;
import java.io.Serializable;

public class GestionArchivageView
extends BackOfficeLongView
implements PopupListener {
    @Override
    public String getMainStyleName() {
        return "import-donnees";
    }

    @Override
    public void enterIn(ViewChangeListener.ViewChangeEvent event) {
        this.refresh();
    }

    public void refresh() {
        this.removeAllComponents();
        ParametresArchivageDTO dto = new ParametresService().getParametresArchivage();
        this.addLabelH1(this, "Gestion des archives");
        this.addLabel(this, "Cet outil vous permet de transf\u00e9rer vers les archives les contrats termin\u00e9s, les utilisateurs qui n'ont pas r\u00e9 adher\u00e9s et les producteurs qui ne livrent plus<br/>");
        this.addLabel(this, "Les \u00e9l\u00e9ments archiv\u00e9s sont toujours accessibles (dans le menu ARCHIVES) et il est possible de les remettre \u00e0 l'\u00e9tat actif");
        this.addLabel(this, "Cet outil vous permet \u00e9galement de supprimer les anciennes p\u00e9riodes de cotisation et de permanence, et aussi de nettoyer les archives (suppression d\u00e9finitive des \u00e9l\u00e9ments).");
        this.addLabel(this, "<b>Pour utiliser cet outil , le plus simple est de cliquer sur les boutons dans l'ordre (de haut en bas)</b>");
        this.addLabel(this, "Vous cliquez d'abord sur \"V\u00e9rifier / Modifier les param\u00e8tres d'archivage\" pour v\u00e9rifier votre param\u00e9trage, puis vous cliquez sur \"Archiver les contrats termin\u00e9s\" puis ...");
        this.addLabel(this, "Pour chaque action, l'outil vous pr\u00e9sentera ce qu'il va faire et vous demandera confirmation avat d'agir.");
        Button b = this.addButton(this, "V\u00e9rifier / Modifier les param\u00e8tres d'archivage", (Button.ClickListener & Serializable)e -> new PopupSaisieParametresArchivage().open(this));
        b.setWidth("60%");
        Panel p1 = new Panel("Transfert vers les archives");
        p1.addStyleName("action");
        p1.setContent(this.getTransfertPanel(dto));
        p1.setWidth("60%");
        Panel p2 = new Panel("Suppression directe");
        p2.addStyleName("action");
        p2.setContent(this.getSuppressionDirectePanel(dto));
        p2.setWidth("60%");
        Panel p3 = new Panel("Nettoyage des archives");
        p3.addStyleName("action");
        p3.setContent(this.getSuppressionPanel(dto));
        p3.setWidth("60%");
        this.addEmptyLine(this);
        this.addComponent((Component)p1);
        this.addEmptyLine(this);
        this.addComponent((Component)p3);
        this.addEmptyLine(this);
        this.addComponent((Component)p2);
    }

    private Component getTransfertPanel(ParametresArchivageDTO dto) {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addButton(layout, "Archiver les contrats termin\u00e9s depuis " + dto.archivageContrat + " jours", (Button.ClickListener & Serializable)e -> new PopupArchivageContrat().open());
        this.addButton(layout, "Archiver les utilisateurs qui n'ont pas r\u00e9 adh\u00e9r\u00e9s", (Button.ClickListener & Serializable)e -> new PopupArchivageUtilisateur().open());
        this.addButton(layout, "Archiver les producteurs qui ne livrent plus", (Button.ClickListener & Serializable)e -> new PopupArchivageProducteur().open());
        return layout;
    }

    private Component getSuppressionDirectePanel(ParametresArchivageDTO dto) {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addButton(layout, "Supprimer les p\u00e9riodes de cotisations termin\u00e9es depuis " + dto.suppressionPeriodeCotisation + " jours", (Button.ClickListener & Serializable)e -> new PopupSuppressionPeriodeCotisation().open());
        this.addButton(layout, "Supprimer les p\u00e9riodes de permanence termin\u00e9es depuis " + dto.suppressionPeriodePermanence + " jours", (Button.ClickListener & Serializable)e -> new PopupSuppressionPeriodePermanence().open());
        return layout;
    }

    private Component getSuppressionPanel(ParametresArchivageDTO dto) {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addButton(layout, "Supprimer les contrats archiv\u00e9s et termin\u00e9s depuis " + dto.suppressionContrat + " jours", (Button.ClickListener & Serializable)e -> new PopupSuppressionContrat().open());
        this.addButton(layout, "Supprimer les utilisateurs archiv\u00e9s trop anciens", (Button.ClickListener & Serializable)e -> new PopupSuppressionUtilisateur().open());
        this.addButton(layout, "Supprimer les producteurs archiv\u00e9s trop anciens", (Button.ClickListener & Serializable)e -> new PopupSuppressionProducteur().open());
        return layout;
    }

    private Button addButton(VerticalLayout layout, String caption, Button.ClickListener listener) {
        Button b = new Button(caption);
        b.setWidth("100%");
        b.addClickListener(listener);
        layout.addComponent((Component)b);
        return b;
    }

    private Label addLabelH1(VerticalLayout layout, String str) {
        Label tf = new Label(str);
        tf.addStyleName("titre");
        layout.addComponent((Component)tf);
        return tf;
    }

    private Label addLabel(VerticalLayout layout, String str) {
        Label tf = new Label(str, ContentMode.HTML);
        layout.addComponent((Component)tf);
        return tf;
    }

    private Label addEmptyLine(VerticalLayout layout) {
        Label tf = new Label("<br/>", ContentMode.HTML);
        layout.addComponent((Component)tf);
        return tf;
    }

    @Override
    public void onPopupClose() {
        this.refresh();
    }
}

