/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.archivage.gestion;

import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.service.services.archivage.ArchivageContratService;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupArchivageContrat
extends WizardFormPopup {
    private ComplexTableBuilder<ModeleContratSummaryDTO> builder;
    private List<ModeleContratSummaryDTO> modeleContratToArchive;
    private List<ModeleContratSummaryDTO> modeleContrats;
    private ParametresArchivageDTO param;

    public PopupArchivageContrat() {
        this.setWidth(80);
        this.popupTitle = "Archivage des contrats";
        this.param = new ParametresService().getParametresArchivage();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldSaisieContrat(), () -> this.readContratsToArchive());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va rechercher la liste des contrats qu'il est souhaitable d'archiver";
        this.addHtml(str);
        str = new ArchivageContratService().computeArchivageLib(this.param);
        this.addHtml(str);
        str = "Vous pourrez alors choisir dans cette liste ceux que vous voulez archiver et ceux que vous voulez conserver.";
        this.addHtml(str);
    }

    private void addFieldSaisieContrat() {
        this.setStepTitle("les contrats \u00e0 archiver");
        this.modeleContrats = new ArchivageContratService().getAllContratsArchivables(this.param);
        this.modeleContratToArchive = new ArrayList<ModeleContratSummaryDTO>();
        if (this.modeleContrats.size() == 0) {
            this.addHtml("Il n'y a pas de contrats \u00e0 archiver.");
            this.setBackOnlyMode();
            return;
        }
        this.builder = new ComplexTableBuilder<ModeleContratSummaryDTO>(this.modeleContrats);
        this.builder.setPageLength(7);
        this.builder.addString("Nom du contrat", false, 300, e -> e.nom);
        this.builder.addString("Nom du producteur", false, 300, e -> e.nomProducteur);
        this.builder.addDate("Premi\u00e8re livraison", false, 150, e -> e.dateDebut);
        this.builder.addDate("Derni\u00e8re livraison", false, 150, e -> e.dateFin);
        this.builder.addCheckBox("Archiver ce contrat", "cb", true, 150, e -> true, null);
        this.addComplexTable(this.builder);
    }

    private String readContratsToArchive() {
        this.modeleContratToArchive = this.builder.getSelectedCheckBox("cb");
        if (this.modeleContratToArchive.size() == 0) {
            return "Vous devez selectionner au moins un contrat pour pouvoir continuer.";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation");
        this.addHtml("Vous allez archiver " + this.modeleContratToArchive.size() + " contrats");
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        for (ModeleContratSummaryDTO mc : this.modeleContratToArchive) {
            try {
                new GestionContratService().updateEtat(EtatModeleContrat.ARCHIVE, mc.id);
            }
            catch (Exception e) {
                throw new OnSaveException("Impossible d'archiver le contrat " + mc.nom + ". Raison : " + e.getMessage());
            }
        }
    }
}

