/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.archivage.gestion;

import fr.amapj.model.models.fichierbase.EtatProducteur;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.producteur.ProducteurDTO;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupArchivageProducteur
extends WizardFormPopup {
    private ComplexTableBuilder<ProducteurDTO> builder;
    private List<ProducteurDTO> producteurToArchive;
    private List<ProducteurDTO> producteurs;
    private ParametresArchivageDTO param;

    public PopupArchivageProducteur() {
        this.setWidth(80);
        this.popupTitle = "Archivage des producteurs";
        this.param = new ParametresService().getParametresArchivage();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldSaisie(), () -> this.readSaisie());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va rechercher la liste des producteurs qu'il est souhaitable d'archiver";
        this.addHtml(str);
        str = new ProducteurService().computeArchivageLib(this.param);
        this.addHtml(str);
        str = "Vous pourrez alors choisir dans cette liste ceux que vous voulez archiver et ceux que vous voulez conserver.";
        this.addHtml(str);
    }

    private void addFieldSaisie() {
        this.setStepTitle("les producteurs \u00e0 archiver");
        this.producteurs = new ProducteurService().getAllProducteursArchivables(this.param);
        this.producteurToArchive = new ArrayList<ProducteurDTO>();
        if (this.producteurs.size() == 0) {
            this.addHtml("Il n'y a pas de producteurs \u00e0 archiver.");
            this.setBackOnlyMode();
            return;
        }
        this.builder = new ComplexTableBuilder<ProducteurDTO>(this.producteurs);
        this.builder.setPageLength(7);
        this.builder.addString("Nom du producteur", false, 300, e -> e.nom);
        this.builder.addDate("Date de cr\u00e9ation du producteur", false, 150, e -> e.dateCreation);
        this.builder.addDate("Date de derni\u00e8re livraison du producteur", false, 150, e -> e.dateDerniereLivraison);
        this.builder.addCheckBox("Archiver ce producteur", "cb", true, 150, e -> false, null);
        this.addComplexTable(this.builder);
    }

    private String readSaisie() {
        this.producteurToArchive = this.builder.getSelectedCheckBox("cb");
        if (this.producteurToArchive.size() == 0) {
            return "Vous devez selectionner au moins un producteur pour pouvoir continuer.";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation");
        this.addHtml("Vous allez archiver " + this.producteurToArchive.size() + " producteurs");
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        for (ProducteurDTO p : this.producteurToArchive) {
            try {
                new ProducteurService().updateEtat(p.id, EtatProducteur.ARCHIVE);
            }
            catch (Exception e) {
                throw new OnSaveException("Impossible d'archiver le producteur " + p.nom + ". Raison : " + e.getMessage());
            }
        }
    }
}

