/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.archivage.gestion;

import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.service.services.archivage.ArchivageUtilisateurService;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupArchivageUtilisateur
extends WizardFormPopup {
    private ComplexTableBuilder<UtilisateurDTO> builder;
    private List<UtilisateurDTO> toArchive;
    private List<UtilisateurDTO> archivables;
    private ParametresArchivageDTO param;

    public PopupArchivageUtilisateur() {
        this.setWidth(80);
        this.popupTitle = "Archivage des utilisateurs";
        this.param = new ParametresService().getParametresArchivage();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldSaisieContrat(), () -> this.readContratsToArchive());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va rechercher la liste des utilisateurs qu'il est souhaitable d'archiver";
        this.addHtml(str);
        str = new ArchivageUtilisateurService().computeArchivageLib(this.param);
        this.addHtml(str);
        str = "Vous pourrez alors choisir dans cette liste ceux que vous voulez archiver et ceux que vous voulez conserver.";
        this.addHtml(str);
    }

    private void addFieldSaisieContrat() {
        this.setStepTitle("les utilisateurs \u00e0 archiver");
        this.archivables = new ArchivageUtilisateurService().getAllUtilisateursArchivables(this.param);
        this.toArchive = new ArrayList<UtilisateurDTO>();
        if (this.archivables.size() == 0) {
            this.addHtml("Il n'y a pas d'utilisateurs \u00e0 archiver.");
            this.setBackOnlyMode();
            return;
        }
        this.builder = new ComplexTableBuilder<UtilisateurDTO>(this.archivables);
        this.builder.setPageLength(7);
        this.builder.addString("Nom de l'utilisateur", false, 300, e -> e.nom);
        this.builder.addString("Pr\u00e9nom de l'utilisateur", false, 300, e -> e.prenom);
        this.builder.addCheckBox("Archiver cet utilisateur", "cb", true, 150, e -> true, null);
        this.addComplexTable(this.builder);
    }

    private String readContratsToArchive() {
        this.toArchive = this.builder.getSelectedCheckBox("cb");
        if (this.toArchive.size() == 0) {
            return "Vous devez selectionner au moins un utilisateur pour pouvoir continuer.";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation");
        this.addHtml("Vous allez archiver " + this.toArchive.size() + " utilisateurs");
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        for (UtilisateurDTO p : this.toArchive) {
            try {
                new UtilisateurService().updateEtat(EtatUtilisateur.INACTIF, p.id);
            }
            catch (Exception e) {
                throw new OnSaveException("Impossible d'archiver l'utilisateur " + p.nom + " " + p.prenom + ". Raison : " + e.getMessage());
            }
        }
    }
}

