/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.archivage.gestion;

import fr.amapj.service.services.archivage.ArchivageContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupSuppressionContrat
extends WizardFormPopup {
    private ComplexTableBuilder<ModeleContratSummaryDTO> builder;
    private List<ModeleContratSummaryDTO> modeleContratToSuppress;
    private List<ModeleContratSummaryDTO> modeleContrats;
    private ParametresArchivageDTO param;

    public PopupSuppressionContrat() {
        this.setWidth(80);
        this.popupTitle = "Suppression des contrats archiv\u00e9s trop anciens";
        this.param = new ParametresService().getParametresArchivage();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldSaisieContrat(), () -> this.readContratsToArchive());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va rechercher la liste des contrats qu'il est souhaitable de supprimer";
        this.addHtml(str);
        str = new ArchivageContratService().computeSuppressionLib(this.param);
        this.addHtml(str);
        str = "Vous pourrez alors choisir dans cette liste ceux que vous voulez archiver et ceux que vous voulez conserver.";
        this.addHtml(str);
    }

    private void addFieldSaisieContrat() {
        this.setStepTitle("les contrats \u00e0 supprimer");
        this.modeleContrats = new ArchivageContratService().getAllContratSupprimables(this.param);
        this.modeleContratToSuppress = new ArrayList<ModeleContratSummaryDTO>();
        if (this.modeleContrats.size() == 0) {
            this.addHtml("Il n'y a pas de contrats \u00e0 supprimer.");
            this.setBackOnlyMode();
            return;
        }
        this.builder = new ComplexTableBuilder<ModeleContratSummaryDTO>(this.modeleContrats);
        this.builder.setPageLength(7);
        this.builder.addString("Nom du contrat", false, 300, e -> e.nom);
        this.builder.addString("Nom du producteur", false, 300, e -> e.nomProducteur);
        this.builder.addDate("Premi\u00e8re livraison", false, 150, e -> e.dateDebut);
        this.builder.addDate("Derni\u00e8re livraison", false, 150, e -> e.dateFin);
        this.builder.addCheckBox("Supprimer ce contrat", "cb", true, 150, e -> true, null);
        this.addComplexTable(this.builder);
    }

    private String readContratsToArchive() {
        this.modeleContratToSuppress = this.builder.getSelectedCheckBox("cb");
        if (this.modeleContratToSuppress.size() == 0) {
            return "Vous devez selectionner au moins un contrat pour pouvoir continuer.";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation");
        this.addHtml("Vous allez supprimer DEFINITIVEMENT " + this.modeleContratToSuppress.size() + " contrats");
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        for (ModeleContratSummaryDTO mc : this.modeleContratToSuppress) {
            try {
                new ArchivageContratService().deleteModeleContratAndContrats(mc.id);
            }
            catch (Exception e) {
                throw new OnSaveException("Impossible de supprimer le contrat " + mc.nom + ". Raison : " + e.getMessage());
            }
        }
    }
}

