/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.archivage.gestion;

import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationDTO;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupSuppressionPeriodeCotisation
extends WizardFormPopup {
    private ComplexTableBuilder<PeriodeCotisationDTO> builder;
    private List<PeriodeCotisationDTO> toSuppress;
    private List<PeriodeCotisationDTO> dtos;
    private ParametresArchivageDTO param;

    public PopupSuppressionPeriodeCotisation() {
        this.setWidth(80);
        this.popupTitle = "Suppression des p\u00e9riodes de cotisations trop anciennes";
        this.param = new ParametresService().getParametresArchivage();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldSaisieContrat(), () -> this.readContratsToArchive());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va rechercher la liste des p\u00e9riodes de cotisations qu'il est souhaitable de supprimer";
        this.addHtml(str);
        str = new GestionCotisationService().computeSuppressionLib(this.param);
        this.addHtml(str);
    }

    private void addFieldSaisieContrat() {
        this.setStepTitle("les p\u00e9riodes de cotisation \u00e0 supprimer");
        this.dtos = new GestionCotisationService().getAllPeriodeCotisationSupprimables(this.param);
        this.toSuppress = new ArrayList<PeriodeCotisationDTO>();
        if (this.dtos.size() == 0) {
            this.addHtml("Il n'y a pas de p\u00e9riodes de cotisation \u00e0 supprimer.");
            this.setBackOnlyMode();
            return;
        }
        this.builder = new ComplexTableBuilder<PeriodeCotisationDTO>(this.dtos);
        this.builder.setPageLength(7);
        this.builder.addString("Nom de la p\u00e9riode", false, 300, e -> e.nom);
        this.builder.addDate("Date de D\u00e9but de la p\u00e9riode", false, 150, e -> e.dateDebut);
        this.builder.addDate("Date de fin de la p\u00e9riode", false, 150, e -> e.dateFin);
        this.builder.addCheckBox("Supprimer cette p\u00e9riode de cotisation", "cb", true, 150, e -> true, null);
        this.addComplexTable(this.builder);
    }

    private String readContratsToArchive() {
        this.toSuppress = this.builder.getSelectedCheckBox("cb");
        if (this.toSuppress.size() == 0) {
            return "Vous devez selectionner au moins une p\u00e9riode de cotisation pour pouvoir continuer.";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation");
        this.addHtml("Vous allez supprimer DEFINITIVEMENT " + this.toSuppress.size() + " periodes de cotisation");
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        for (PeriodeCotisationDTO mc : this.toSuppress) {
            try {
                new GestionCotisationService().deleteWithInscrits(mc.id);
            }
            catch (Exception e) {
                throw new OnSaveException("Impossible de supprimer la p\u00e9riode de cotisation " + mc.nom + ". Raison : " + e.getMessage());
            }
        }
    }
}

