/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.archivage.producteur;

import fr.amapj.model.models.fichierbase.EtatProducteur;
import fr.amapj.service.services.producteur.ProducteurDTO;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.views.archivage.producteur.PopupProducteurRetourActif;
import fr.amapj.view.views.archivage.producteur.PopupProducteurSuppression;
import fr.amapj.view.views.producteur.basicform.ProducteurVoirPart;
import java.util.List;

public class ArchivageProducteurListPart
extends StandardListPart<ProducteurDTO> {
    public ArchivageProducteurListPart() {
        super(ProducteurDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des producteurs archiv\u00e9s";
    }

    @Override
    protected void drawButton() {
        this.addButton("Voir", ButtonType.EDIT_MODE, e -> new ProducteurVoirPart((ProducteurDTO)e));
        this.addButton("Remettre actif", ButtonType.EDIT_MODE, e -> new PopupProducteurRetourActif((ProducteurDTO)e));
        this.addButton("Supprimer d\u00e9finitivement", ButtonType.EDIT_MODE, e -> new PopupProducteurSuppression((ProducteurDTO)e));
        this.addSearchField("Rechercher par nom");
    }

    @Override
    protected void drawTable() {
        this.addColumn("nom", "Nom");
        this.addColumn("utilisateurInfo", "Producteurs");
        this.addColumn("referentInfo", "Referents");
        this.addColumn("nbModeleContratActif", "Nb contrats").center();
        this.addColumnDate("dateDerniereLivraison", "Derni\u00e8re liv");
        this.addColumnDate("dateCreation", "Date cr\u00e9ation");
    }

    @Override
    protected List<ProducteurDTO> getLines() {
        return new ProducteurService().getAllProducteurs(EtatProducteur.ARCHIVE);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"dateCreation"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom"};
    }
}

