/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.common.gapviewer;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.DateUtils;
import fr.amapj.common.GenericUtils;
import fr.amapj.common.periode.TypPeriode;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.common.gapviewer.AbstractGapViewer;
import fr.amapj.view.views.common.gapviewer.DateProvider;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DatePerDateViewer
implements AbstractGapViewer {
    private PopupListener listener;
    private DateProvider dateProvider;
    private Label titre;
    private Date currentDate;

    public DatePerDateViewer(DateProvider dateProvider, PopupListener listener) {
        this.dateProvider = dateProvider;
        this.listener = listener;
        Date now = DateUtils.getDateWithNoTime();
        GenericUtils.Ret<Date> nextDate = dateProvider.provideDate(now, true);
        this.currentDate = nextDate.isOK() ? nextDate.get() : now;
    }

    @Override
    public VerticalLayout getComponent() {
        VerticalLayout vl = new VerticalLayout();
        vl.setMargin(false);
        vl.setSpacing(false);
        vl.addStyleName("date-viewer");
        HorizontalLayout hl1 = new HorizontalLayout();
        hl1.setWidth("100%");
        this.addButton(false, hl1, (Button.ClickListener & Serializable)e -> this.reculer());
        Label empty = new Label();
        hl1.addComponent((Component)empty);
        hl1.setExpandRatio((Component)empty, 1.0f);
        this.addButton(true, hl1, (Button.ClickListener & Serializable)e -> this.avancer());
        vl.addComponent((Component)hl1);
        this.titre = new Label();
        hl1.addStyleName("titre");
        this.titre.setSizeUndefined();
        vl.addComponent((Component)this.titre);
        vl.setComponentAlignment((Component)this.titre, Alignment.MIDDLE_CENTER);
        this.updateTitreValue();
        return vl;
    }

    private void avancer() {
        GenericUtils.Ret<Date> d = this.dateProvider.provideDate(DateUtils.addDays(this.currentDate, 1), true);
        if (!d.isOK()) {
            Notification.show((String)"Impossible", (String)d.msg(), (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
            return;
        }
        this.currentDate = d.get();
        this.updateTitreValue();
        this.listener.onPopupClose();
    }

    private void reculer() {
        GenericUtils.Ret<Date> d = this.dateProvider.provideDate(this.currentDate, false);
        if (!d.isOK()) {
            Notification.show((String)"Impossible", (String)d.msg(), (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
            return;
        }
        this.currentDate = d.get();
        this.updateTitreValue();
        this.listener.onPopupClose();
    }

    private Button addButton(boolean toRight, HorizontalLayout layout, Button.ClickListener listener) {
        String str = toRight ? "SUIVANT" : "PRECEDENT";
        Button b = new Button(str);
        b.addClickListener(listener);
        if (toRight) {
            b.setIcon((Resource)FontAwesome.ANGLE_DOUBLE_RIGHT);
            b.addStyleName("icon-align-right");
            b.addStyleName("large");
        } else {
            b.setIcon((Resource)FontAwesome.ANGLE_DOUBLE_LEFT);
            b.addStyleName("large");
        }
        b.addStyleName("fleche");
        layout.addComponent((Component)b);
        return b;
    }

    private void updateTitreValue() {
        String toDisplay = this.getTitreValue();
        this.titre.setValue(toDisplay);
    }

    private String getTitreValue() {
        int delay = DateUtils.getDeltaDay(DateUtils.getDateWithNoTime(), this.currentDate);
        if (delay == -1) {
            return "hier";
        }
        if (delay == 0) {
            return "aujourd'hui";
        }
        if (delay == 1) {
            return "demain";
        }
        if (delay < 0) {
            if (delay < -60) {
                return "il y a " + -delay / 30 + " mois";
            }
            return "il y a " + -delay + " jours";
        }
        if (delay > 60) {
            return "dans " + delay / 30 + " mois";
        }
        return "dans " + delay + " jours";
    }

    @Override
    public Date getDateDebut() {
        return this.currentDate;
    }

    @Override
    public Date getDateFin() {
        return this.currentDate;
    }

    @Override
    public TypPeriode getTypPeriode() {
        return TypPeriode.JOUR;
    }

    public VerticalLayout getAdditionnalInfoIfEmpty() {
        SimpleDateFormat dfx = BaseUiTools.isWidthBelow(480) ? new SimpleDateFormat("dd/MM/yy") : new SimpleDateFormat("EEEEE dd MMMMM yyyy");
        VerticalLayout vl = new VerticalLayout();
        Label label = new Label(dfx.format(this.currentDate));
        label.addStyleName("titre");
        label.setSizeUndefined();
        vl.addComponent((Component)label);
        vl.setComponentAlignment((Component)label, Alignment.MIDDLE_CENTER);
        return vl;
    }
}

