/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.common.gapviewer;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.DateUtils;
import fr.amapj.common.periode.TypPeriode;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.common.gapviewer.AbstractGapViewer;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WeekViewer
implements AbstractGapViewer {
    private SimpleDateFormat df1 = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
    private SimpleDateFormat df2 = new SimpleDateFormat("dd/MM/yy");
    private Label titre;
    private Date date = DateUtils.firstMonday(this.date);
    private PopupListener listener;

    public WeekViewer(PopupListener listener) {
        this.listener = listener;
    }

    @Override
    public VerticalLayout getComponent() {
        VerticalLayout vl = new VerticalLayout();
        vl.setMargin(false);
        vl.setSpacing(false);
        vl.addStyleName("semaine-viewer");
        HorizontalLayout hl1 = new HorizontalLayout();
        hl1.setWidth("100%");
        this.addButton(false, hl1, (Button.ClickListener & Serializable)e -> this.reculer());
        Label empty = new Label();
        hl1.addComponent((Component)empty);
        hl1.setExpandRatio((Component)empty, 1.0f);
        this.addButton(true, hl1, (Button.ClickListener & Serializable)e -> this.avancer());
        vl.addComponent((Component)hl1);
        this.titre = new Label();
        hl1.addStyleName("titre");
        this.titre.setSizeUndefined();
        vl.addComponent((Component)this.titre);
        vl.setComponentAlignment((Component)this.titre, Alignment.MIDDLE_CENTER);
        this.updateTitreValue();
        return vl;
    }

    private void avancer() {
        this.date = DateUtils.addDays(this.date, 7);
        this.updateTitreValue();
        this.listener.onPopupClose();
    }

    private void reculer() {
        this.date = DateUtils.addDays(this.date, -7);
        this.updateTitreValue();
        this.listener.onPopupClose();
    }

    private void addButton(boolean toRight, HorizontalLayout layout, Button.ClickListener listener) {
        String str = BaseUiTools.isWidthBelow(480) ? (toRight ? "SUIVANT" : "PRECEDENT") : (toRight ? "SEMAINE SUIVANTE" : "SEMAINE PRECEDENTE");
        Button b = new Button(str);
        b.addClickListener(listener);
        if (toRight) {
            b.setIcon((Resource)FontAwesome.ANGLE_DOUBLE_RIGHT);
            b.addStyleName("icon-align-right");
            b.addStyleName("large");
        } else {
            b.setIcon((Resource)FontAwesome.ANGLE_DOUBLE_LEFT);
            b.addStyleName("large");
        }
        b.addStyleName("fleche");
        layout.addComponent((Component)b);
    }

    private void updateTitreValue() {
        SimpleDateFormat dfx = BaseUiTools.isWidthBelow(480) ? this.df2 : this.df1;
        this.titre.setValue(String.valueOf(dfx.format(this.getDateDebut())) + " - " + dfx.format(this.getDateFin()));
    }

    @Override
    public Date getDateDebut() {
        return this.date;
    }

    @Override
    public Date getDateFin() {
        return DateUtils.addDays(this.date, 6);
    }

    @Override
    public TypPeriode getTypPeriode() {
        return TypPeriode.SEMAINE;
    }
}

