/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.common.utilisateurselector;

import com.vaadin.data.Property;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.searcher.SearcherList;
import java.io.Serializable;

public class UtilisateurSelectorPart {
    private Searcher utilisateurBox;
    private Long idUtilisateur;
    private Button reinitButton;
    private PopupListener listener;
    private boolean isCompactMode;

    public UtilisateurSelectorPart(PopupListener listener) {
        this.listener = listener;
        this.isCompactMode = BaseUiTools.isCompactMode();
    }

    public HorizontalLayout getChoixUtilisateurComponent() {
        HorizontalLayout toolbar1 = new HorizontalLayout();
        toolbar1.addStyleName("utilisateur-selectorpart");
        this.constructMultipleUtilisateur(toolbar1);
        toolbar1.setSpacing(true);
        toolbar1.setWidth("100%");
        return toolbar1;
    }

    private void constructMultipleUtilisateur(HorizontalLayout toolbar1) {
        if (!this.isCompactMode) {
            Label pLabel = new Label("Amapien");
            pLabel.addStyleName("xutilisateurs");
            pLabel.setSizeUndefined();
            toolbar1.addComponent((Component)pLabel);
        }
        this.utilisateurBox = new Searcher(SearcherList.UTILISATEUR_ACTIF, null);
        this.utilisateurBox.setImmediate(true);
        this.utilisateurBox.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.handleUtilisateurChange());
        this.reinitButton = new Button("Changer d'amapien");
        this.reinitButton.addClickListener((Button.ClickListener & Serializable)e -> this.handleReinit());
        toolbar1.addComponent((Component)this.utilisateurBox);
        toolbar1.addComponent((Component)this.reinitButton);
        toolbar1.setExpandRatio((Component)this.reinitButton, 1.0f);
        toolbar1.setComponentAlignment((Component)this.reinitButton, Alignment.TOP_RIGHT);
    }

    private void handleUtilisateurChange() {
        this.idUtilisateur = (Long)this.utilisateurBox.getConvertedValue();
        if (this.idUtilisateur != null) {
            this.utilisateurBox.setEnabled(false);
        }
        this.listener.onPopupClose();
    }

    protected void handleReinit() {
        this.utilisateurBox.setValue(null);
        this.utilisateurBox.setEnabled(true);
        this.idUtilisateur = null;
        this.listener.onPopupClose();
    }

    public Long getUtilisateurId() {
        return this.idUtilisateur;
    }
}

