/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.contratsamapien;

import com.vaadin.ui.Component;
import fr.amapj.model.engine.IdentifiableUtil;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.contratsamapien.AmapienContratDTO;
import fr.amapj.service.services.contratsamapien.AmapienContratsService;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.cascadingpopup.CInfo;
import fr.amapj.view.engine.popup.cascadingpopup.CascadingData;
import fr.amapj.view.engine.popup.cascadingpopup.CascadingPopup;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.views.common.amapientelecharger.TelechargerAmapien;
import fr.amapj.view.views.common.utilisateurselector.UtilisateurSelectorPart;
import fr.amapj.view.views.contratsamapien.PopupSaisieProducteurContrat;
import fr.amapj.view.views.receptioncheque.ReceptionChequeEditorPart;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.util.List;

public class ContratsAmapienListPart
extends StandardListPart<AmapienContratDTO> {
    private UtilisateurSelectorPart utilisateurSelector;
    private List<Producteur> allowedProducteurs = new AccessManagementService().getAccessLivraisonProducteur(SessionManager.getUserRoles(), SessionManager.getUserId(), false);

    public ContratsAmapienListPart() {
        super(AmapienContratDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des contrats d'un amapien";
    }

    @Override
    protected void addSelectorComponent() {
        this.utilisateurSelector = new UtilisateurSelectorPart(this);
        this.addComponent((Component)this.utilisateurSelector.getChoixUtilisateurComponent());
    }

    @Override
    protected void drawButton() {
        this.addButtonAction("Ajouter nouveau contrat", ButtonType.ALWAYS, () -> this.handleAjouter());
        this.addButtonAction("Visualiser", ButtonType.EDIT_MODE, () -> this.handleVisualiser());
        this.addButtonAction("Modifier quantit\u00e9s", ButtonType.EDIT_MODE, () -> this.handleModifier());
        this.addButton("R\u00e9ceptionner ch\u00e8ques", ButtonType.EDIT_MODE, e -> this.handleReceptionCheque());
        this.addButtonAction("Modifier ch\u00e9ques", ButtonType.EDIT_MODE, () -> this.handleModifierCheque());
        this.addButton("Supprimer contrat", ButtonType.EDIT_MODE, e -> this.handleSupprimer());
        this.addButton("T\u00e9l\u00e9charger ...", ButtonType.ALWAYS, e -> this.handleTelecharger());
        this.addSearchField("Rechercher par nom");
    }

    @Override
    protected void drawTable() {
        this.addColumn("nomProducteur", "Producteur");
        this.addColumn("nomContrat", "Contrat");
        this.addColumnDate("dateDebut", "Premi\u00e8re livraison");
        this.addColumnDate("dateFin", "Derni\u00e8re livraison");
        this.addColumnDateTime("dateCreation", "Date cr\u00e9ation");
        this.addColumnDateTime("dateModification", "Date modification");
        this.addColumnCurrency("montant", "Montant (en \u20ac)").right();
    }

    @Override
    protected List<AmapienContratDTO> getLines() {
        Long idUser = this.utilisateurSelector.getUtilisateurId();
        if (idUser == null) {
            return null;
        }
        return new AmapienContratsService().getAllContratsDTO(idUser);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"dateFin", "nomProducteur"};
    }

    @Override
    protected boolean[] getSortAsc() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        return blArray;
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nomContrat", "nomProducteur"};
    }

    private void handleVisualiser() {
        AmapienContratDTO dto = (AmapienContratDTO)this.getSelectedLine();
        String message = "Visualisation du contrat de " + dto.prenomUtilisateur + " " + dto.nomUtilisateur;
        Long idUtilisateur = this.utilisateurSelector.getUtilisateurId();
        SaisieContrat.saisieContrat(dto.idModeleContrat, dto.idContrat, idUtilisateur, message, SaisieContrat.ModeSaisie.READ_ONLY, this);
    }

    protected void handleModifier() {
        AmapienContratDTO dto = (AmapienContratDTO)this.getSelectedLine();
        String message = "Contrat de " + dto.prenomUtilisateur + " " + dto.nomUtilisateur;
        Long idUtilisateur = this.utilisateurSelector.getUtilisateurId();
        SaisieContrat.saisieContrat(dto.idModeleContrat, dto.idContrat, idUtilisateur, message, SaisieContrat.ModeSaisie.QTE_SEUL, this);
    }

    protected CorePopup handleSupprimer() {
        AmapienContratDTO dto = (AmapienContratDTO)this.getSelectedLine();
        String text = "Etes vous s\u00fbr de vouloir supprimer le contrat de " + dto.prenomUtilisateur + " " + dto.nomUtilisateur + " ?";
        return new SuppressionPopup(text, dto.idContrat, e -> new MesContratsService().deleteContrat((Long)e));
    }

    @Override
    protected boolean isEditAllowed() {
        AmapienContratDTO dto = (AmapienContratDTO)this.getSelectedLine();
        if (dto == null) {
            return false;
        }
        return IdentifiableUtil.contains(this.allowedProducteurs, dto.idProducteur);
    }

    private void handleAjouter() {
        AjouterData data = new AjouterData();
        data.userId = this.utilisateurSelector.getUtilisateurId();
        CascadingPopup cascading = new CascadingPopup(this, data);
        CInfo info = new CInfo();
        info.popup = new PopupSaisieProducteurContrat(data);
        info.onSuccess = () -> this.successSaisieContrat(data);
        cascading.start(info);
    }

    private CInfo successSaisieContrat(AjouterData data) {
        Long userId = data.userId;
        String message = "Contrat de " + new UtilisateurService().prettyString(userId);
        SaisieContrat.saisieContrat(data.idModeleContrat, null, userId, message, SaisieContrat.ModeSaisie.QTE_CHEQUE_REFERENT, this);
        return null;
    }

    private void handleModifierCheque() {
        AmapienContratDTO dto = (AmapienContratDTO)this.getSelectedLine();
        String message = "Modification des ch\u00e8ques de " + dto.prenomUtilisateur + " " + dto.nomUtilisateur;
        SaisieContrat.saisieContrat(dto.idModeleContrat, dto.idContrat, dto.idUtilisateur, message, SaisieContrat.ModeSaisie.CHEQUE_SEUL, this);
    }

    private CorePopup handleReceptionCheque() {
        AmapienContratDTO dto = (AmapienContratDTO)this.getSelectedLine();
        return new ReceptionChequeEditorPart(dto.idContrat, dto.nomUtilisateur, dto.prenomUtilisateur);
    }

    private CorePopup handleTelecharger() {
        Long idUtilisateur = this.utilisateurSelector.getUtilisateurId();
        return TelechargerAmapien.handleTelecharger(idUtilisateur);
    }

    public class AjouterData
    extends CascadingData {
        Long idModeleContrat;
        Long userId;
    }
}

