/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.contratsamapien;

import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.model.models.param.paramecran.PEContratAmapien;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.popup.okcancelpopup.OKCancelPopup;
import fr.amapj.view.views.common.contratselector.ContratSelectorPart;
import fr.amapj.view.views.contratsamapien.ContratsAmapienListPart;

public class PopupSaisieProducteurContrat
extends OKCancelPopup
implements PopupListener {
    private ContratSelectorPart contratSelectorPart;
    private ContratsAmapienListPart.AjouterData data;
    private PEContratAmapien peEcran;

    public PopupSaisieProducteurContrat(ContratsAmapienListPart.AjouterData data) {
        this.data = data;
        this.popupTitle = "Selection du contrat";
        this.saveButtonTitle = "Continuer ...";
        this.setType(CorePopup.PopupType.CENTERFIT);
        this.peEcran = (PEContratAmapien)new ParametresService().loadParamEcran(MenuList.CONTRATS_AMAPIEN);
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.contratSelectorPart = new ContratSelectorPart(this, true);
        HorizontalLayout toolbar1 = this.contratSelectorPart.getChoixContratComponent();
        contentLayout.addComponent((Component)toolbar1);
        this.contratSelectorPart.fillAutomaticValues();
    }

    @Override
    protected boolean performSauvegarder() {
        boolean hasAdhesion;
        Long idModeleContrat = this.contratSelectorPart.getModeleContratId();
        if (idModeleContrat == null) {
            return false;
        }
        boolean hasContrat = new GestionContratSigneService().checkIfUserHasContrat(idModeleContrat, this.data.userId);
        if (hasContrat) {
            new MessagePopup("Impossible", CorePopup.ColorStyle.RED, "Cet utilisateur poss\u00e8de d\u00e9j\u00e0 ce contrat.").open();
            return false;
        }
        if (this.peEcran.gestionAjoutContrat == PEContratAmapien.GestionAjoutContrat.VERIFICATION_ADHESION && !(hasAdhesion = new GestionContratSigneService().checkIfUserHasAdhesion(idModeleContrat, this.data.userId))) {
            new MessagePopup("Impossible", CorePopup.ColorStyle.RED, "Cet utilisateur n'est pas \u00e0 jour de son adh\u00e9sion pour ce contrat.").open();
            return false;
        }
        this.data.validate();
        this.data.idModeleContrat = idModeleContrat;
        return true;
    }

    @Override
    public void onPopupClose() {
    }
}

