/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.cotisation.bilan;

import fr.amapj.service.services.editionspe.EditionSpeService;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationDTO;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.views.searcher.SearcherList;

public class PeriodeCotisationEditorPart
extends WizardFormPopup {
    private PeriodeCotisationDTO dto;

    public PeriodeCotisationEditorPart(boolean create, PeriodeCotisationDTO p) {
        this.setWidth(80);
        if (create) {
            this.popupTitle = "Cr\u00e9ation d'une p\u00e9riode d'adh\u00e9sion";
            this.dto = new PeriodeCotisationDTO();
        } else {
            this.popupTitle = "Modification d'une p\u00e9riode d'adh\u00e9sion";
            this.dto = p;
        }
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldGeneral());
        this.add(() -> this.addFieldPaiement());
    }

    private void addFieldGeneral() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales de la p\u00e9riode d'adh\u00e9sion");
        NotNullValidator notNull = new NotNullValidator();
        this.addTextField("Nom de la p\u00e9riode", "nom", notNull);
        this.addDateField("Date de d\u00e9but de la p\u00e9riode", "dateDebut", notNull);
        this.addDateField("Date de fin de la p\u00e9riode", "dateFin", notNull);
    }

    private void addFieldPaiement() {
        new NotNullValidator();
        this.setStepTitle("les informations sur le paiement de l'adh\u00e9sion");
        this.addCurrencyField("Montant minimum", "montantMini", false);
        this.addCurrencyField("Montant conseill\u00e9", "montantConseille", false);
        this.addTextField("Ordre du ch\u00e8que", "libCheque", new IValidator[0]);
        this.addTextAeraField("Texte explicatif pour le paiement", "textPaiement");
        if (new EditionSpeService().fichePeriodeNeedBulletinAdhesion()) {
            this.addSearcher("Mod\u00e8le de bulletin d'adhesion", "idBulletinAdhesion", SearcherList.BULLETIN_ADHESION, null, new IValidator[0]);
        }
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        new GestionCotisationService().createOrUpdate(this.dto);
    }
}

