/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.cotisation.reception;

import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import fr.amapj.common.CollectionUtils;
import fr.amapj.model.models.cotisation.EtatPaiementAdhesion;
import fr.amapj.model.models.cotisation.TypePaiementAdhesion;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationDTO;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationUtilisateurDTO;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.swicthpopup.SwitchPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.io.Serializable;
import java.util.List;

public class AjouterEnMasseAdhesion
extends WizardFormPopup {
    private List<PeriodeCotisationUtilisateurDTO> lines;
    private ComplexTableBuilder<PeriodeCotisationUtilisateurDTO> builder;
    private PeriodeCotisationDTO periode;

    public AjouterEnMasseAdhesion(Long idPeriodeCotisation) {
        this.popupTitle = "Cr\u00e9ation en masse des adh\u00e9sions";
        this.setHeight("100%");
        this.setWidth(100);
        this.lines = new GestionCotisationService().getAllForAjouterEnMasse(idPeriodeCotisation);
        CollectionUtils.sort(this.lines, e -> e.nomUtilisateur, e -> e.prenomUtilisateur);
        this.periode = new GestionCotisationService().load(idPeriodeCotisation);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfo());
        this.add(() -> this.addFieldSaisie(), () -> this.writeToModel());
    }

    protected void addFieldInfo() {
        String str = "Cet \u00e9cran permet de cr\u00e9er en masse les adh\u00e9sions<br/><br/>Dans un cas standard, cet \u00e9cran n'est pas n\u00e9cessaire : en effet, les adh\u00e9rents cr\u00e9ent eux m\u00eame leur adh\u00e9sion en allant dans Mes Adh\u00e9sions<br/><br/>Cet \u00e9cran est utile surtout quand vous mettez en place AMAPJ dans votre AMAP, pour cr\u00e9er toutes les adh\u00e9sions d\u00e9j\u00e0 existantes<br/><br/>Dans l'\u00e9cran suivant, si vous remplissez le champ montant, alors l'adh\u00e9sion sera cr\u00e9\u00e9e<br/>Toutes les lignes avec montant=0 seront ignor\u00e9es";
        this.addHtml(str);
    }

    protected void addFieldSaisie() {
        if (this.lines.size() == 0) {
            this.addHtml("Il n'y a pas de cotisation \u00e0 cr\u00e9er");
            this.setWidth(60);
            return;
        }
        this.builder = new ComplexTableBuilder<PeriodeCotisationUtilisateurDTO>(this.lines);
        this.builder.addString("Nom", false, 200, e -> e.nomUtilisateur);
        this.builder.addString("Prenom", false, 200, e -> e.prenomUtilisateur);
        this.builder.addCurrency("Montant", "mnt", true, 100, e -> e.montantAdhesion);
        this.builder.addCombo("Etat du paiement", "etat", true, 200, e -> e.etatPaiementAdhesion, EtatPaiementAdhesion.class);
        this.builder.addCombo("Type du paiement", "type", true, 200, e -> e.typePaiementAdhesion, TypePaiementAdhesion.class);
        this.builder.setPageLength(11);
        this.addComplexTable(this.builder);
        Button b = new Button("Mettre toutes colonnes \u00e0 ...", (Button.ClickListener & Serializable)e -> this.handleToutMontant());
        this.form.addComponent((Component)b);
    }

    private void handleToutMontant() {
        SwitchPopup popup = new SwitchPopup("Actions possibles", 60);
        popup.addLineAction("Positionner toute la colonne Montant avec la valeur " + new CurrencyTextFieldConverter().convertToString(this.periode.montantConseille) + " \u20ac", () -> this.colonneMontant());
        popup.addSeparator();
        popup.addLineAction("Positionner toute la colonne Etat du paiement avec la valeur A FOURNIR", () -> this.colonneEtatPaiement(EtatPaiementAdhesion.A_FOURNIR));
        popup.addLineAction("Positionner toute la colonne Etat du paiement avec la valeur ENCAISSE", () -> this.colonneEtatPaiement(EtatPaiementAdhesion.ENCAISSE));
        popup.addSeparator();
        popup.addLineAction("Positionner toute la colonne Type du paiement avec la valeur CHEQUE", () -> this.colonneTypePaiement(TypePaiementAdhesion.CHEQUE));
        popup.addLineAction("Positionner toute la colonne Type du paiement avec la valeur ESPECES", () -> this.colonneTypePaiement(TypePaiementAdhesion.ESPECES));
        popup.addLineAction("Positionner toute la colonne Type du paiement avec la valeur VIREMENT", () -> this.colonneTypePaiement(TypePaiementAdhesion.VIREMENT));
        popup.addLineAction("Positionner toute la colonne Type du paiement avec la valeur INTERNET", () -> this.colonneTypePaiement(TypePaiementAdhesion.INTERNET));
        popup.open();
    }

    private void colonneTypePaiement(TypePaiementAdhesion type) {
        int i = 0;
        while (i < this.lines.size()) {
            ComboBox cb = (ComboBox)this.builder.getComponent(i, "type");
            cb.setValue((Object)type);
            ++i;
        }
    }

    private void colonneEtatPaiement(EtatPaiementAdhesion etat) {
        int i = 0;
        while (i < this.lines.size()) {
            ComboBox cb = (ComboBox)this.builder.getComponent(i, "etat");
            cb.setValue((Object)etat);
            ++i;
        }
    }

    private void colonneMontant() {
        int i = 0;
        while (i < this.lines.size()) {
            TextField cb = (TextField)this.builder.getComponent(i, "mnt");
            cb.setConvertedValue((Object)this.periode.montantConseille);
            ++i;
        }
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        for (PeriodeCotisationUtilisateurDTO pcu : this.lines) {
            if (pcu.montantAdhesion == 0) continue;
            new GestionCotisationService().createOrUpdateCotisation(true, pcu);
        }
    }

    private String writeToModel() {
        String str = "";
        int i = 0;
        while (i < this.lines.size()) {
            PeriodeCotisationUtilisateurDTO line = this.lines.get(i);
            TextField mnt = (TextField)this.builder.getComponent(i, "mnt");
            ComboBox etat = (ComboBox)this.builder.getComponent(i, "etat");
            ComboBox type = (ComboBox)this.builder.getComponent(i, "type");
            line.montantAdhesion = (Integer)mnt.getConvertedValue();
            line.etatPaiementAdhesion = (EtatPaiementAdhesion)((Object)etat.getValue());
            line.typePaiementAdhesion = (TypePaiementAdhesion)((Object)type.getValue());
            if (line.montantAdhesion != 0 && (line.etatPaiementAdhesion == null || line.typePaiementAdhesion == null)) {
                str = String.valueOf(str) + "Erreur \u00e0 la ligne " + line.nomUtilisateur + " " + line.prenomUtilisateur + " : Etat du paiement ou Type du paiement n'est pas renseign\u00e9<br/>";
            }
            ++i;
        }
        return str.length() == 0 ? null : str;
    }
}

