/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.cotisation.reception;

import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import fr.amapj.common.DateUtils;
import fr.amapj.model.models.cotisation.EtatPaiementAdhesion;
import fr.amapj.service.services.gestioncotisation.BilanAdhesionDTO;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationUtilisateurDTO;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

public class ReceptionnerEnMasseAdhesion
extends WizardFormPopup {
    private List<PeriodeCotisationUtilisateurDTO> lines;
    private ComplexTableBuilder<PeriodeCotisationUtilisateurDTO> builder;

    public ReceptionnerEnMasseAdhesion(Long idPeriodeCotisation) {
        this.popupTitle = "R\u00e9ception en masse des adh\u00e9sions";
        this.setHeight("100%");
        this.setWidth(100);
        BilanAdhesionDTO bilanAdhesionDTO = new GestionCotisationService().loadBilanAdhesion(idPeriodeCotisation);
        this.lines = bilanAdhesionDTO.utilisateurDTOs.stream().filter(e -> e.etatPaiementAdhesion == EtatPaiementAdhesion.A_FOURNIR).collect(Collectors.toList());
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldSaisie(), () -> this.writeToModel());
    }

    private void addFieldSaisie() {
        if (this.lines.size() == 0) {
            this.addHtml("Il n'y a pas de d'adhesion \u00e0 r\u00e9ceptionner");
            this.setWidth(60);
            return;
        }
        this.builder = new ComplexTableBuilder<PeriodeCotisationUtilisateurDTO>(this.lines);
        this.builder.addString("Nom", false, 200, e -> e.nomUtilisateur);
        this.builder.addString("Prenom", false, 200, e -> e.prenomUtilisateur);
        this.builder.addCurrency("Montant", "mnt", false, 100, e -> e.montantAdhesion);
        this.builder.addCheckBox("R\u00e9ceptionn\u00e9", "cb", true, 200, e -> false, null);
        this.builder.addString("Type du paiement", "type", false, 200, e -> "" + (Object)((Object)e.typePaiementAdhesion));
        this.builder.setPageLength(13);
        this.addComplexTable(this.builder);
        Button b = new Button("Tout cocher", (Button.ClickListener & Serializable)e -> this.handleToutCocher());
        this.form.addComponent((Component)b);
    }

    private void handleToutCocher() {
        int i = 0;
        while (i < this.lines.size()) {
            CheckBox cb = (CheckBox)this.builder.getComponent(i, "cb");
            cb.setValue((Object)true);
            ++i;
        }
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        for (PeriodeCotisationUtilisateurDTO pcu : this.lines) {
            if (pcu.etatPaiementAdhesion != EtatPaiementAdhesion.ENCAISSE) continue;
            new GestionCotisationService().createOrUpdateCotisation(false, pcu);
        }
    }

    private String writeToModel() {
        int i = 0;
        while (i < this.lines.size()) {
            PeriodeCotisationUtilisateurDTO line = this.lines.get(i);
            CheckBox cb = (CheckBox)this.builder.getComponent(i, "cb");
            if (((Boolean)cb.getValue()).booleanValue()) {
                line.etatPaiementAdhesion = EtatPaiementAdhesion.ENCAISSE;
                line.dateReceptionCheque = DateUtils.getDate();
            }
            ++i;
        }
        return null;
    }
}

