/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.droits;

import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.access.AdminTresorierDTO;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.views.droits.AdminTresorierEditorPart;
import java.util.List;

public class DroitsTresorierListPart
extends StandardListPart<AdminTresorierDTO> {
    public DroitsTresorierListPart() {
        super(AdminTresorierDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des tr\u00e9soriers";
    }

    @Override
    protected void drawButton() {
        this.addButton("Ajouter un tr\u00e9sorier", ButtonType.ALWAYS, e -> new AdminTresorierEditorPart(false));
        this.addButton("Supprimer un tr\u00e9sorier", ButtonType.EDIT_MODE, e -> this.handleSupprimer());
        this.addSearchField("Rechercher par nom ou prenom");
    }

    @Override
    protected void drawTable() {
        this.addColumn("nom", "Nom");
        this.addColumn("prenom", "Prenom");
    }

    @Override
    protected List<AdminTresorierDTO> getLines() {
        return new AccessManagementService().getAllTresorier();
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nom", "prenom"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom", "prenom"};
    }

    private CorePopup handleSupprimer() {
        AdminTresorierDTO dto = (AdminTresorierDTO)this.getSelectedLine();
        String text = "Etes vous s\u00fbr de vouloir supprimer le droit tr\u00e9sorier \u00e0 " + dto.nom + " " + dto.prenom + " ?";
        return new SuppressionPopup(text, dto.id, e -> new AccessManagementService().deleteTresorier((Long)e));
    }
}

