/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.editionspe;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.services.editionspe.EditionSpeDTO;
import fr.amapj.service.services.editionspe.EditionSpeService;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.engine.popup.swicthpopup.SwitchPopup;
import fr.amapj.view.views.editionspe.DupliquerEditionSpeEditorPart;
import fr.amapj.view.views.editionspe.EtiquetteProducteurEditorPart;
import fr.amapj.view.views.editionspe.FeuilleEmargementEditorPart;
import fr.amapj.view.views.editionspe.bilanlivraison.BilanLivraisonEditorPart;
import fr.amapj.view.views.editionspe.bulletinadhesion.BulletinAdhesionEditorPart;
import fr.amapj.view.views.editionspe.engagement.EngagementEditorPart;
import java.util.List;

public class EditionSpeListPart
extends StandardListPart<EditionSpeDTO> {
    public EditionSpeListPart() {
        super(EditionSpeDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des \u00e9ditions sp\u00e9cifiques";
    }

    @Override
    protected void drawButton() {
        this.addButton("Cr\u00e9er une nouvelle \u00e9dition sp\u00e9cifique", ButtonType.ALWAYS, e -> this.handleAjouter());
        this.addButton("Modifier", ButtonType.EDIT_MODE, e -> this.handleEditer());
        this.addButton("Dupliquer", ButtonType.EDIT_MODE, e -> new DupliquerEditionSpeEditorPart((EditionSpeDTO)e));
        this.addButton("Supprimer", ButtonType.EDIT_MODE, e -> this.handleSupprimer());
        this.addSearchField("Rechercher par nom ");
    }

    @Override
    protected void drawTable() {
        this.addColumn("nom", "Nom");
        this.addColumn("typEditionSpecifique", "Type de l'\u00e9dition");
    }

    @Override
    protected List<EditionSpeDTO> getLines() {
        return new EditionSpeService().getAllEtiquettes();
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nom"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom"};
    }

    private SwitchPopup handleAjouter() {
        SwitchPopup popup = new SwitchPopup("Choix de l'\u00e9dition sp\u00e9cifique \u00e0 cr\u00e9er", 50);
        popup.addLine("Un nouveau document d'engagement", () -> new EngagementEditorPart(true, null));
        popup.addLine("Un nouveau bulletin d'adh\u00e9sion", () -> new BulletinAdhesionEditorPart(true, null));
        popup.addLine("Une nouvelle \u00e9tiquette", () -> new EtiquetteProducteurEditorPart(true, null));
        popup.addLine("Une nouvelle feuille d'\u00e9margement (mensuelle ou hebdomadaire)", () -> new FeuilleEmargementEditorPart(true, null));
        popup.addLine("Un nouveau bilan de livraison", () -> new BilanLivraisonEditorPart(true, null));
        return popup;
    }

    protected CorePopup handleEditer() {
        EditionSpeDTO dto = (EditionSpeDTO)this.getSelectedLine();
        switch (dto.typEditionSpecifique) {
            case ETIQUETTE_PRODUCTEUR: {
                return new EtiquetteProducteurEditorPart(false, dto);
            }
            case FEUILLE_EMARGEMENT: {
                return new FeuilleEmargementEditorPart(false, dto);
            }
            case CONTRAT_ENGAGEMENT: {
                return new EngagementEditorPart(false, dto);
            }
            case BULLETIN_ADHESION: {
                return new BulletinAdhesionEditorPart(false, dto);
            }
            case BILAN_LIVRAISON: {
                return new BilanLivraisonEditorPart(false, dto);
            }
        }
        throw new AmapjRuntimeException("Erreur");
    }

    protected SuppressionPopup handleSupprimer() {
        EditionSpeDTO dto = (EditionSpeDTO)this.getSelectedLine();
        String text = "Etes vous s\u00fbr de vouloir supprimer l'\u00e9dition sp\u00e9cifique " + dto.nom + " ?";
        return new SuppressionPopup(text, dto.id, e -> new EditionSpeService().delete((Long)e));
    }
}

