/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.editionspe.bulletinadhesion;

import com.vaadin.ui.Component;
import com.vaadin.ui.Link;
import fr.amapj.common.ObjectUtils;
import fr.amapj.common.ResourceUtils;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.editionspe.PageFormat;
import fr.amapj.model.models.editionspe.adhesion.BulletinAdhesionJson;
import fr.amapj.service.engine.generator.pdf.PdfHtmlUtils;
import fr.amapj.service.services.edgenerator.pdf.PGBulletinAdhesion;
import fr.amapj.service.services.editionspe.EditionSpeDTO;
import fr.amapj.service.services.editionspe.EditionSpeService;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.engine.popup.formpopup.validator.UniqueInDatabaseValidator;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.views.editionspe.bulletinadhesion.BulletinAdhesionTemplate;
import fr.amapj.view.views.searcher.SearcherList;

public class BulletinAdhesionEditorPart
extends WizardFormPopup {
    private BulletinAdhesionJson etiquetteDTO;
    private boolean create;
    private BulletinAdhesionTemplate templateSelected = null;

    public BulletinAdhesionEditorPart(boolean create, EditionSpeDTO p) {
        this.create = create;
        this.setWidth(90);
        this.setHeight("90%");
        if (create) {
            this.popupTitle = "Cr\u00e9ation d'un mod\u00e8le de bulletin d'adh\u00e9sion";
            this.etiquetteDTO = new BulletinAdhesionJson();
        } else {
            this.popupTitle = "Modification d'un mod\u00e8le de bulletin d'adh\u00e9sion";
            this.etiquetteDTO = (BulletinAdhesionJson)new EditionSpeService().load(p.id);
        }
        this.setModel(this.etiquetteDTO);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldGeneral());
        this.add(() -> this.addFieldMarges());
        this.add(() -> this.addFieldText());
        this.add(() -> this.addFieldTest());
    }

    private void addFieldGeneral() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales");
        UniqueInDatabaseValidator uniq = new UniqueInDatabaseValidator(EditionSpecifique.class, "nom", this.etiquetteDTO.getId());
        this.addTextField("Nom", "nom", uniq);
        if (this.create) {
            this.addComboEnumField("Modele de d\u00e9part", "template", new NotNullValidator());
            String content = "Plusieurs mod\u00e9les de d\u00e9part sont propos\u00e9s<br>Il est conseill\u00e9 d'essayer les diff\u00e9rents mod\u00e8les, de voir celui qui est le plus proche de votre besoin, puis de l'adapter ensuite<br/>";
            this.addHtml(content);
        }
    }

    private void addFieldMarges() {
        if (this.create && !ObjectUtils.equals(this.templateSelected, this.etiquetteDTO.getTemplate())) {
            String filename = "template/" + this.etiquetteDTO.getTemplate().name().toLowerCase() + ".html";
            String template = ResourceUtils.toString(this, filename);
            this.etiquetteDTO.setText(template);
            this.etiquetteDTO.setMargeBas(10);
            this.etiquetteDTO.setMargeHaut(10);
            this.etiquetteDTO.setMargeDroite(10);
            this.etiquetteDTO.setMargeGauche(10);
            this.etiquetteDTO.setPageFormat(this.etiquetteDTO.getTemplate().getPageFormat());
            this.templateSelected = this.etiquetteDTO.getTemplate();
        }
        this.setStepTitle("les informations de marges et de disposition");
        this.addIntegerField("Marge droite (en mm)", "margeDroite", new IValidator[0]);
        this.addIntegerField("Marge gauche (en mm)", "margeGauche", new IValidator[0]);
        this.addIntegerField("Marge en haut (en mm)", "margeHaut", new IValidator[0]);
        this.addIntegerField("Marge en bas (en mm)", "margeBas", new IValidator[0]);
        Enum[] toExclude = new PageFormat[]{PageFormat.A3_PAYSAGE, PageFormat.A3_PORTRAIT};
        this.addComboEnumField("Disposition de la page", "pageFormat", toExclude, new IValidator[]{new NotNullValidator()});
    }

    private void addFieldText() {
        String c = PdfHtmlUtils.updateHeaderAndBodyLineForCKEditor(this.etiquetteDTO.getText(), this.etiquetteDTO);
        this.etiquetteDTO.setText(c);
        this.setStepTitle("le contenu du bulletin");
        this.addCKEditorFieldForDocument("text");
    }

    private void addFieldTest() {
        this.setStepTitle("tester le bulletin d'adh\u00e9sion");
        Searcher s = this.addSearcher("P\u00e9riode de cotisation qui servira pour tester", "idPeriodeCotisation", SearcherList.PERIODE_COTISATION, null, new IValidator[0]);
        s.setBuffered(false);
        Link link = LinkCreator.createLink(PGBulletinAdhesion.testMode(this.etiquetteDTO));
        link.setCaption("Cliquer ici pour tester cette \u00e9dition");
        this.form.addComponent((Component)link);
    }

    @Override
    protected void performSauvegarder() {
        new EditionSpeService().update(this.etiquetteDTO, this.create);
    }
}

