/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart;

import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.GridSizeCalculator;
import fr.amapj.view.engine.grid.booleangrid.PopupBooleanGrid;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.text.SimpleDateFormat;

public class BarrerDateContratEditorPart
extends PopupBooleanGrid {
    private SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
    private ContratDTO contratDTO;
    private Long idModeleContrat;

    public BarrerDateContratEditorPart(Long idModeleContrat) {
        this.idModeleContrat = idModeleContrat;
    }

    @Override
    public void loadParam() {
        this.contratDTO = new MesContratsService().loadContrat(this.idModeleContrat, null);
        this.popupTitle = "Barrer des dates pour le contrat " + this.contratDTO.nom;
        this.setWidth(90);
        this.param.messageSpecifique = null;
        this.param.nbCol = this.contratDTO.contratColumns.size();
        this.param.nbLig = this.contratDTO.contratLigs.size();
        this.param.box = this.contratDTO.extractExcluded();
        this.param.largeurCol = 110;
        GridHeaderLine line1 = new GridHeaderLine();
        line1.addCell("Produit");
        for (ContratColDTO col : this.contratDTO.contratColumns) {
            line1.addCell(col.nomProduit);
        }
        GridSizeCalculator.autoSize(line1, this.param.largeurCol, "Arial", 16);
        GridHeaderLine line2 = new GridHeaderLine();
        line2.style = GridHeaderLine.GridHeaderLineStyle.PRIX;
        line2.addCell("prix unitaire");
        for (ContratColDTO col : this.contratDTO.contratColumns) {
            line2.addCell(new CurrencyTextFieldConverter().convertToString(col.prix));
        }
        GridHeaderLine line3 = new GridHeaderLine();
        line3.addCell("Dates");
        for (ContratColDTO col : this.contratDTO.contratColumns) {
            line3.addCell(col.condtionnementProduit);
        }
        GridSizeCalculator.autoSize(line3, this.param.largeurCol, "Arial", 16);
        this.param.headerLines.add(line1);
        this.param.headerLines.add(line2);
        this.param.headerLines.add(line3);
        for (ContratLigDTO lig : this.contratDTO.contratLigs) {
            this.param.leftPartLine.add(this.df.format(lig.date));
        }
    }

    @Override
    public void performSauvegarder() throws OnSaveException {
        this.contratDTO.copyInExcluded(this.param.box);
        new GestionContratService().updateDateBarreesModeleContrat(this.contratDTO);
    }

    @Override
    protected String checkInitialCondition() {
        int nbInscrits = new GestionContratService().getNbInscrits(this.idModeleContrat);
        if (nbInscrits != 0) {
            String str = "Vous ne pouvez plus barrer simplement certaines dates ou produits pour ce contrat<br/>car " + nbInscrits + " adh\u00e9rents ont d\u00e9j\u00e0 souscrits \u00e0 ce contrat.<br/><br/>" + "Vous devez aller dans \"Gestion des contrats sign\u00e9s\", puis vous cliquez sur le bouton \"Modifier en masse\",<br> puis sur \"Barrer certaines dates ou certains produits\", et un assistant vous aidera \u00e0 barrer certains produits ou dates en prenant en compte les contrats sign\u00e9s.";
            return str;
        }
        return null;
    }
}

