/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart;

import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.engine.popup.formpopup.validator.StringLengthValidator;
import fr.amapj.view.engine.popup.formpopup.validator.UniqueInDatabaseValidator;
import fr.amapj.view.engine.popup.okcancelpopup.OKCancelMessagePopup;
import fr.amapj.view.views.gestioncontrat.editorpart.GestionContratEditorPart;
import java.io.Serializable;

public class ModifEnteteContratEditorPart
extends GestionContratEditorPart {
    private ComboBox box;

    @Override
    protected void configure() {
        ParametresDTO param = new ParametresService().getParametres();
        this.add(() -> this.drawEntete());
        this.add(param.etatGestionCotisation == EtatModule.ACTIF, () -> this.drawAccess());
        this.add(() -> this.drawFinInscription(false));
    }

    public ModifEnteteContratEditorPart(Long id) {
        this.popupTitle = "Modification d'un contrat";
        this.setWidth(80);
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        this.setModel(this.modeleContrat);
    }

    private void drawEntete() {
        UniqueInDatabaseValidator uniq = new UniqueInDatabaseValidator(ModeleContrat.class, "nom", this.modeleContrat.id);
        StringLengthValidator len_1_100 = new StringLengthValidator(1, 100);
        StringLengthValidator len_1_255 = new StringLengthValidator(1, 255);
        NotNullValidator notNull = new NotNullValidator();
        this.addTextField("Nom du contrat", "nom", uniq, len_1_100);
        this.addTextField("Description du contrat", "description", len_1_255);
        this.box = this.addComboEnumField("Nature du contrat", "nature", notNull);
        this.box.setEnabled(false);
        HorizontalLayout hl = (HorizontalLayout)this.box.getParent();
        Button modif = new Button("Modifier la nature du contrat");
        modif.addClickListener((Button.ClickListener & Serializable)e -> this.handleModifierNature());
        hl.addComponent((Component)modif);
    }

    private void handleModifierNature() {
        String title = "Confirmer";
        String htmlMessage = "Etes vous s\u00fbr de vouloir modifier la nature de ce contrat ?<br/>En effet, modifier la nature d'un contrat modifie totalement le comportement de ce contrat<br/>et en particulier la fa\u00e7on dont les utilisateurs vont pouvoir modifier ce contrat.<br/><br/>Ne faites ceci que si vous \u00eates s\u00fbr de vous.";
        OKCancelMessagePopup popup = new OKCancelMessagePopup(title, htmlMessage, () -> this.box.setEnabled(true));
        OKCancelMessagePopup.open(popup);
    }

    @Override
    protected void performSauvegarder() {
        new GestionContratService().updateEnteteModeleContrat(this.modeleContrat);
    }
}

