/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart;

import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.view.views.gestioncontrat.editorpart.GestionContratEditorPart;

public class ModifJokerContratEditorPart
extends GestionContratEditorPart {
    @Override
    protected void configure() {
        this.add(() -> this.drawRegleJoker(), () -> this.checkJoker());
    }

    public ModifJokerContratEditorPart(Long id) {
        this.setWidth(80);
        this.popupTitle = "Modification des r\u00e8gles de gestion des jokers";
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        this.setModel(this.modeleContrat);
    }

    private void drawRegleJoker() {
        this.setStepTitle("les r\u00e8gles de gestion des jokers");
        this.addBlocGestionJoker();
    }

    @Override
    protected void performSauvegarder() {
        new GestionContratService().updateJoker(this.modeleContrat);
    }

    @Override
    protected String checkInitialCondition() {
        if (this.modeleContrat.nature != NatureContrat.ABONNEMENT) {
            return "Les jokers sont utilisables uniquement avec les contrats de type abonnement.";
        }
        int nbInscrits = new GestionContratService().getNbInscrits(this.modeleContrat.id);
        if (nbInscrits != 0) {
            String str = "Vous ne pouvez plus modifier les r\u00e8gles de gestion des jokers pour ce contrat<br/>car " + nbInscrits + " adh\u00e9rents ont d\u00e9j\u00e0 souscrits \u00e0 ce contrat.<br/>" + "Si vous souhaitez vraiment modifier les r\u00e8gles de gestion des jokers, vous devez aller dans \"Gestion des contrats sign\u00e9s\", puis vous cliquez sur le bouton \"Modifier en masse\".<br/>";
            return str;
        }
        return null;
    }
}

