/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart;

import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.mespaiements.PaiementService;
import fr.amapj.view.views.gestioncontrat.editorpart.GestionContratEditorPart;
import fr.amapj.view.views.gestioncontrat.editorpart.utils.GestionContratPaiementUtils;

public class ModifPaiementContratEditorPart
extends GestionContratEditorPart {
    public ModifPaiementContratEditorPart(Long id) {
        this.setWidth(80);
        this.popupTitle = "Modification des conditions de paiement d'un contrat";
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        new GestionContratPaiementUtils().checkAndUpdateStrategieAndSaisiePaiementCalculDate(this.modeleContrat);
        this.setModel(this.modeleContrat);
    }

    @Override
    protected void configure() {
        this.add(() -> this.drawTypePaiement(null), () -> this.checkTypePaiement());
        this.add(() -> this.drawDetailPaiement(true));
    }

    @Override
    protected void performSauvegarder() {
        new PaiementService().updateInfoPaiement(this.modeleContrat, true);
    }

    @Override
    protected String checkInitialCondition() {
        int nbInscrits = new GestionContratService().getNbInscrits(this.modeleContrat.id);
        if (nbInscrits != 0) {
            String str = "Vous ne pouvez plus modifier les conditions de paiement de ce contrat<br/>car " + nbInscrits + " adh\u00e9rents ont d\u00e9j\u00e0 souscrits \u00e0 ce contrat<br/>." + "Si vous souhaitez vraiment modifier les conditions de paiement, vous devez aller dans \"Gestion des contrats sign\u00e9s\", puis vous cliquez sur le bouton \"Modifier en masse\".<br/>";
            return str;
        }
        return null;
    }
}

