/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart;

import com.vaadin.ui.Component;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.LigneContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.produit.ProduitService;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.FormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionNoDuplicates;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionSizeValidator;
import fr.amapj.view.engine.popup.formpopup.validator.ColumnNotNull;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.views.searcher.SDProduit;
import fr.amapj.view.views.searcher.SearcherList;

public class ModifProduitContratEditorPart
extends FormPopup {
    private ModeleContratDTO modeleContrat;

    public ModifProduitContratEditorPart(Long id) {
        this.popupTitle = "Modification des produits d'un contrat";
        this.setWidth(80);
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        this.setModel(this.modeleContrat);
    }

    @Override
    protected void addFields() {
        Searcher prod = new Searcher(SearcherList.PRODUCTEUR);
        prod.bind(this.binder, "producteur");
        this.form.addComponent((Component)prod);
        prod.setEnabled(false);
        CollectionSizeValidator size = new CollectionSizeValidator(1, null);
        CollectionNoDuplicates<LigneContratDTO> noDuplicates = new CollectionNoDuplicates<LigneContratDTO>(e -> e.produitId, e -> new ProduitService().prettyString(e.produitId));
        this.addCollectionEditorField("Produits", "produits", LigneContratDTO.class, size, noDuplicates);
        this.addColumnSearcher("produitId", "Nom du produit", FieldType.SEARCHER, null, new SDProduit(prod), prod, new ColumnNotNull<LigneContratDTO>(e -> e.produitId));
        this.addColumn("prix", "Prix du produit", FieldType.CURRENCY, null, new ColumnNotNull<LigneContratDTO>(e -> e.prix));
    }

    @Override
    protected void performSauvegarder() {
        new GestionContratService().updateProduitModeleContrat(this.modeleContrat);
    }

    @Override
    protected String checkInitialCondition() {
        int nbInscrits = new GestionContratService().getNbInscrits(this.modeleContrat.id);
        if (nbInscrits != 0) {
            String str = "Vous ne pouvez plus modifier directement les produits ou les prix de ce contrat<br/>car " + nbInscrits + " adh\u00e9rents ont d\u00e9j\u00e0 souscrits \u00e0 ce contrat.<br/>" + "Si vous souhaitez vraiment modifier les prix ou les produits , vous devez aller dans \"Gestion des contrats sign\u00e9s\", puis vous cliquez sur le bouton \"Modifier en masse\".<br/>" + "Vous avez alors 3 possibilit\u00e9s :<ul>" + "<li>Vous pouvez ajouter des produits</li>" + "<li>Vous pouvez supprimer des produits</li>" + "<li>Vous pouvez modifier les prix</li>" + "</ul>";
            return str;
        }
        return null;
    }
}

