/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart.reglesaisie;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.services.gestioncontrat.reglesaisie.RegleSaisieDTO;
import fr.amapj.service.services.gestioncontrat.reglesaisie.RegleSaisieModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.reglesaisie.RegleSaisieModeleContratService;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.views.gestioncontrat.editorpart.reglesaisie.RegleSaisieOneRegleEditorPart;
import java.io.Serializable;
import java.util.List;

public class RegleSaisieModeleContratEditorPart
extends WizardFormPopup {
    private RegleSaisieModeleContratDTO dto;
    private VerticalLayout reglesPart;

    public RegleSaisieModeleContratEditorPart(Long idModeleContrat) {
        this.setWidth(80);
        this.popupTitle = "R\u00e8gles de saisie d'un mod\u00e8le de contrat";
        this.dto = new RegleSaisieModeleContratService().getRegleSaisieModeleContratDTO(idModeleContrat);
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addInfo());
        this.add(() -> this.addField());
    }

    private void addInfo() {
        this.setStepTitle("Informations g\u00e9n\u00e9rales");
        this.addHtml("Cet outil vous permet d'indiquer des r\u00e8gles qui devront \u00eatre respect\u00e9es lors de la saisie des quantit\u00e9s sur un contrat.<br/><br/>Par exemple, il est possible d'indiquer que tel produit devra \u00eatre command\u00e9 au moins 3 fois sur la totalit\u00e9 du contrat.<br/><br/>Autre exemple : pour des raisons de conditionnement, vous pouvez indiquer que la somme des produits A,B et C doit \u00eatre un multiple de 6.");
    }

    private void addField() {
        this.setStepTitle("R\u00e8gles de saisie");
        this.reglesPart = new VerticalLayout();
        this.form.addComponent((Component)this.reglesPart);
        this.refreshReglesPart();
        Button add = new Button("Ajouter une r\u00e8gle");
        add.addClickListener((Button.ClickListener & Serializable)e -> this.addRegle());
        this.form.addComponent((Component)add);
    }

    private void refreshReglesPart() {
        this.reglesPart.removeAllComponents();
        if (this.dto.regleSaisies.size() == 0) {
            this.reglesPart.addComponent((Component)new Label("Aucune r\u00e8gle de saisie pour ce mod\u00e8le de contrat"));
        }
        List<RegleSaisieDTO> regleSaisies = this.dto.regleSaisies;
        int i = 0;
        while (i < regleSaisies.size()) {
            RegleSaisieDTO regleSaisie = regleSaisies.get(i);
            HorizontalLayout hl = new HorizontalLayout();
            hl.setWidth("100%");
            Label l = new Label(this.getText(regleSaisie, i), ContentMode.HTML);
            hl.addComponent((Component)l);
            hl.setExpandRatio((Component)l, 1.0f);
            Button b1 = new Button("Modifier");
            b1.addClickListener((Button.ClickListener & Serializable)e -> this.updateRegle(regleSaisie));
            hl.addComponent((Component)b1);
            Button b2 = new Button("Supprimer");
            b2.addClickListener((Button.ClickListener & Serializable)e -> this.suppressRegle(regleSaisie));
            hl.addComponent((Component)b2);
            this.reglesPart.addComponent((Component)hl);
            this.reglesPart.addComponent((Component)new Label(""));
            ++i;
        }
    }

    private String getText(RegleSaisieDTO regleSaisie, int i) {
        String s = "<b>R\u00e8gle " + (i + 1) + " :</b>" + regleSaisie.libelle + "<br/>Champ d'application:" + (Object)((Object)regleSaisie.champApplication);
        if (regleSaisie.activateLibPersonnalise == ChoixOuiNon.OUI) {
            s = String.valueOf(s) + "<br/>Cette r\u00e8gle poss\u00e9de un libell\u00e9 personnalis\u00e9.";
        }
        return s;
    }

    private void suppressRegle(RegleSaisieDTO regleSaisie) {
        this.dto.regleSaisies.remove(regleSaisie);
        this.refreshReglesPart();
    }

    private void updateRegle(RegleSaisieDTO regleSaisie) {
        RegleSaisieOneRegleEditorPart popup = new RegleSaisieOneRegleEditorPart(this.dto, regleSaisie);
        popup.open(() -> this.refreshReglesPart());
    }

    private void addRegle() {
        RegleSaisieOneRegleEditorPart popup = new RegleSaisieOneRegleEditorPart(this.dto, null);
        popup.open(() -> this.refreshReglesPart());
    }

    @Override
    protected void performSauvegarder() {
        new RegleSaisieModeleContratService().saveRegleSaisieModeleContrat(this.dto);
    }
}

