/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart.utils;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.SaisiePaiementCalculDate;
import fr.amapj.service.services.gestioncontrat.DateModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.DatePaiementModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class GestionContratDateUtils {
    public void computeDateLivraison(ModeleContratDTO modeleContrat) {
        List<Date> dates;
        switch (modeleContrat.frequence) {
            case UNE_SEULE_LIVRAISON: {
                dates = this.getUneSeuleLivraison(modeleContrat);
                break;
            }
            case UNE_FOIS_PAR_SEMAINE: {
                dates = this.getUneFoisParSemaine(modeleContrat);
                break;
            }
            case QUINZE_JOURS: {
                dates = this.getQuinzeJours(modeleContrat);
                break;
            }
            case UNE_FOIS_PAR_MOIS: {
                dates = this.getUneFoisParMois(modeleContrat);
                break;
            }
            case AUTRE: {
                dates = this.getAllDatesAutre(modeleContrat.dateLivs);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
        modeleContrat.dateLivs.clear();
        for (Date date : dates) {
            DateModeleContratDTO dto = new DateModeleContratDTO();
            dto.dateLiv = date;
            modeleContrat.dateLivs.add(dto);
        }
        Collections.sort(modeleContrat.dateLivs, (p1, p2) -> p1.dateLiv.compareTo(p2.dateLiv));
    }

    private List<Date> getUneSeuleLivraison(ModeleContratDTO modeleContrat) {
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.add(modeleContrat.dateDebut);
        return dates;
    }

    private List<Date> getUneFoisParSemaine(ModeleContratDTO modeleContrat) {
        return this.computeDateWithDelta(modeleContrat.dateDebut, modeleContrat.dateFin, 7);
    }

    private List<Date> getQuinzeJours(ModeleContratDTO modeleContrat) {
        return this.computeDateWithDelta(modeleContrat.dateDebut, modeleContrat.dateFin, 14);
    }

    private List<Date> computeDateWithDelta(Date dateDebut, Date dateFin, int delta) {
        ArrayList<Date> res = new ArrayList<Date>();
        int cpt = 0;
        while (dateDebut.before(dateFin) || dateDebut.equals(dateFin)) {
            res.add(dateDebut);
            dateDebut = DateUtils.addDays(dateDebut, delta);
            if (++cpt <= 1000) continue;
            throw new AmapjRuntimeException("Erreur dans la saisie des dates");
        }
        return res;
    }

    private List<Date> getUneFoisParMois(ModeleContratDTO modeleContrat) {
        Date dateDebut = modeleContrat.dateDebut;
        Date dateFin = modeleContrat.dateFin;
        ArrayList<Date> res = new ArrayList<Date>();
        int cpt = 0;
        res.add(dateDebut);
        int rank = DateUtils.getDayOfWeekInMonth(dateDebut);
        int delta = 7;
        dateDebut = DateUtils.addDays(dateDebut, delta);
        while (dateDebut.before(dateFin) || dateDebut.equals(dateFin)) {
            ++cpt;
            if (DateUtils.getDayOfWeekInMonth(dateDebut) == rank) {
                res.add(dateDebut);
            }
            dateDebut = DateUtils.addDays(dateDebut, delta);
            if (cpt <= 1000) continue;
            throw new RuntimeException("Erreur dans la saisie des dates");
        }
        return res;
    }

    private List<Date> getAllDatesAutre(List<DateModeleContratDTO> dateLivs) {
        ArrayList<Date> res = new ArrayList<Date>();
        for (DateModeleContratDTO dto : dateLivs) {
            res.add(dto.dateLiv);
        }
        return res;
    }

    public void computeDatePaiement(ModeleContratDTO modeleContrat) {
        if (modeleContrat.gestionPaiement == GestionPaiement.NON_GERE) {
            modeleContrat.datePaiements.clear();
            return;
        }
        if (modeleContrat.saisiePaiementCalculDate == SaisiePaiementCalculDate.AUTRE) {
            return;
        }
        List<Date> res = this.calculDatePaiement(modeleContrat.saisiePaiementCalculDate, modeleContrat.dateLivs);
        modeleContrat.datePaiements.clear();
        for (Date date : res) {
            DatePaiementModeleContratDTO dto = new DatePaiementModeleContratDTO();
            dto.datePaiement = date;
            modeleContrat.datePaiements.add(dto);
        }
    }

    public List<Date> calculDatePaiement(SaisiePaiementCalculDate saisiePaiementCalculDate, List<DateModeleContratDTO> dateLivs) {
        ArrayList<Date> res = new ArrayList<Date>();
        switch (saisiePaiementCalculDate) {
            case UN_PAIEMENT_PAR_LIVRAISON: {
                this.computeUnPaiementParLivraison(dateLivs, res);
                break;
            }
            case UN_PAIEMENT_PAR_MOIS_PREMIERE_LIVRAISON: {
                this.computeUnPaiementParMoisPremiereLivraison(dateLivs, res);
                break;
            }
            case UN_PAIEMENT_PAR_MOIS_DEBUT_MOIS: {
                this.computeUnPaiementParMoisDebutMois(dateLivs, res);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
        return res;
    }

    private void computeUnPaiementParMoisDebutMois(List<DateModeleContratDTO> dateLivs, List<Date> res) {
        Date dateCur = null;
        for (DateModeleContratDTO dateLiv : dateLivs) {
            if (dateCur != null && DateUtils.isSameMonthAndYear(dateCur, dateLiv.dateLiv)) continue;
            dateCur = DateUtils.firstDayInMonth(dateLiv.dateLiv);
            res.add(dateCur);
        }
    }

    private void computeUnPaiementParMoisPremiereLivraison(List<DateModeleContratDTO> dateLivs, List<Date> res) {
        Date dateCur = null;
        for (DateModeleContratDTO dateLiv : dateLivs) {
            if (dateCur != null && DateUtils.isSameMonthAndYear(dateCur, dateLiv.dateLiv)) continue;
            dateCur = dateLiv.dateLiv;
            res.add(dateCur);
        }
    }

    private void computeUnPaiementParLivraison(List<DateModeleContratDTO> dateLivs, List<Date> res) {
        for (DateModeleContratDTO dateLiv : dateLivs) {
            res.add(dateLiv.dateLiv);
        }
    }
}

