/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart.utils;

import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.SaisiePaiementCalculDate;
import fr.amapj.model.models.contrat.modele.SaisiePaiementModifiable;
import fr.amapj.model.models.contrat.modele.SaisiePaiementProposition;
import fr.amapj.model.models.contrat.modele.StrategiePaiement;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.view.views.gestioncontrat.editorpart.utils.GestionContratDateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class GestionContratPaiementUtils {
    public void checkAndUpdateStrategieAndSaisiePaiementCalculDate(ModeleContratDTO modeleContrat) {
        modeleContrat.saisiePaiementCalculDate = this.getSaisiePaiementCalculDate(modeleContrat);
        modeleContrat.strategiePaiement = this.getStrategie(modeleContrat);
    }

    private SaisiePaiementCalculDate getSaisiePaiementCalculDate(ModeleContratDTO modeleContrat) {
        if (modeleContrat.gestionPaiement == GestionPaiement.NON_GERE) {
            return SaisiePaiementCalculDate.AUTRE;
        }
        if (modeleContrat.saisiePaiementCalculDate == SaisiePaiementCalculDate.AUTRE) {
            return SaisiePaiementCalculDate.AUTRE;
        }
        if (this.isSaisiePaiementCalculDateCorrect(modeleContrat)) {
            return modeleContrat.saisiePaiementCalculDate;
        }
        return SaisiePaiementCalculDate.AUTRE;
    }

    private boolean isSaisiePaiementCalculDateCorrect(ModeleContratDTO modeleContrat) {
        List datesInBase = modeleContrat.datePaiements.stream().map(e -> e.datePaiement).collect(Collectors.toList());
        List<Date> datesCalculs = new GestionContratDateUtils().calculDatePaiement(modeleContrat.saisiePaiementCalculDate, modeleContrat.dateLivs);
        return datesCalculs.equals(datesInBase);
    }

    private StrategiePaiement getStrategie(ModeleContratDTO modeleContrat) {
        if (modeleContrat.strategiePaiement == StrategiePaiement.NON_GERE) {
            return StrategiePaiement.NON_GERE;
        }
        if (modeleContrat.strategiePaiement == StrategiePaiement.PLUS_DE_CHOIX) {
            return StrategiePaiement.PLUS_DE_CHOIX;
        }
        StrategiePaiementEntry e = this.find(modeleContrat.strategiePaiement);
        if (!this.isMatching(e, modeleContrat)) {
            return StrategiePaiement.PLUS_DE_CHOIX;
        }
        return modeleContrat.strategiePaiement;
    }

    public void fillFieldPaiementFromStrategie(ModeleContratDTO modeleContrat) {
        StrategiePaiement st = modeleContrat.strategiePaiement;
        if (st == StrategiePaiement.PLUS_DE_CHOIX) {
            modeleContrat.gestionPaiement = GestionPaiement.GESTION_STANDARD;
            return;
        }
        StrategiePaiementEntry e = this.find(st);
        modeleContrat.gestionPaiement = e.gestionPaiement;
        modeleContrat.saisiePaiementProposition = e.saisiePaiementProposition;
        modeleContrat.saisiePaiementModifiable = e.saisiePaiementModifiable;
        modeleContrat.saisiePaiementCalculDate = e.saisiePaiementCalculDate;
        if (e.forceMontantMiniChequeToZero) {
            modeleContrat.montantChequeMiniCalculProposition = 0;
        }
    }

    private boolean isMatching(StrategiePaiementEntry e, ModeleContratDTO modeleContrat) {
        return e.strategiePaiement == modeleContrat.strategiePaiement && e.saisiePaiementProposition == modeleContrat.saisiePaiementProposition && e.saisiePaiementModifiable == modeleContrat.saisiePaiementModifiable && e.saisiePaiementCalculDate == modeleContrat.saisiePaiementCalculDate;
    }

    private StrategiePaiementEntry find(StrategiePaiement strategiePaiement) {
        List<StrategiePaiementEntry> res = this.getAlls();
        for (StrategiePaiementEntry e : res) {
            if (e.strategiePaiement != strategiePaiement) continue;
            return e;
        }
        return null;
    }

    private List<StrategiePaiementEntry> getAlls() {
        ArrayList<StrategiePaiementEntry> res = new ArrayList<StrategiePaiementEntry>();
        res.add(new StrategiePaiementEntry(StrategiePaiement.NON_GERE, GestionPaiement.NON_GERE, SaisiePaiementProposition.REPARTI_STRICT, SaisiePaiementModifiable.NON_MODIFIABLE, SaisiePaiementCalculDate.AUTRE, true));
        res.add(new StrategiePaiementEntry(StrategiePaiement.UN_CHEQUE_PAR_MOIS_LISSE_MODIFIABLE_1ERE_LIVRAISON, GestionPaiement.GESTION_STANDARD, SaisiePaiementProposition.REPARTI_ARRONDI, SaisiePaiementModifiable.MODIFIABLE, SaisiePaiementCalculDate.UN_PAIEMENT_PAR_MOIS_PREMIERE_LIVRAISON, false));
        res.add(new StrategiePaiementEntry(StrategiePaiement.UN_CHEQUE_PAR_MOIS_LISSE_NON_MODIFIABLE_1ERE_LIVRAISON, GestionPaiement.GESTION_STANDARD, SaisiePaiementProposition.REPARTI_ARRONDI, SaisiePaiementModifiable.NON_MODIFIABLE, SaisiePaiementCalculDate.UN_PAIEMENT_PAR_MOIS_PREMIERE_LIVRAISON, false));
        res.add(new StrategiePaiementEntry(StrategiePaiement.UN_PAIEMENT_PAR_LIVRAISON, GestionPaiement.GESTION_STANDARD, SaisiePaiementProposition.PAYE_AVANCE_STRICT, SaisiePaiementModifiable.NON_MODIFIABLE, SaisiePaiementCalculDate.UN_PAIEMENT_PAR_LIVRAISON, true));
        res.add(new StrategiePaiementEntry(StrategiePaiement.UN_CHEQUE_PAR_MOIS_LISSE_MODIFIABLE_1ER_MOIS, GestionPaiement.GESTION_STANDARD, SaisiePaiementProposition.REPARTI_ARRONDI, SaisiePaiementModifiable.MODIFIABLE, SaisiePaiementCalculDate.UN_PAIEMENT_PAR_MOIS_DEBUT_MOIS, false));
        return res;
    }

    public static class StrategiePaiementEntry {
        public StrategiePaiement strategiePaiement;
        public GestionPaiement gestionPaiement;
        public SaisiePaiementProposition saisiePaiementProposition;
        public SaisiePaiementModifiable saisiePaiementModifiable;
        public SaisiePaiementCalculDate saisiePaiementCalculDate;
        public boolean forceMontantMiniChequeToZero;

        public StrategiePaiementEntry(StrategiePaiement strategiePaiement, GestionPaiement gestionPaiement, SaisiePaiementProposition saisiePaiementProposition, SaisiePaiementModifiable saisiePaiementModifiable, SaisiePaiementCalculDate saisiePaiementCalculDate, boolean forceMontantMiniChequeToZero) {
            this.strategiePaiement = strategiePaiement;
            this.gestionPaiement = gestionPaiement;
            this.saisiePaiementProposition = saisiePaiementProposition;
            this.saisiePaiementModifiable = saisiePaiementModifiable;
            this.saisiePaiementCalculDate = saisiePaiementCalculDate;
            this.forceMontantMiniChequeToZero = forceMontantMiniChequeToZero;
        }
    }
}

