/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.listpart;

import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import fr.amapj.common.CollectionUtils;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.view.engine.popup.formpopup.FormPopup;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import fr.amapj.view.views.searcher.SDPeriodeCotisation;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;

public class SaisieEnMassePeriodeCotisation
extends FormPopup {
    private SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
    private List<ModeleContratSummaryDTO> lines;
    private ComplexTableBuilder<ModeleContratSummaryDTO> builder;
    private SortMode sortMode;
    private Button tri;

    public SaisieEnMassePeriodeCotisation() {
        this.popupTitle = "Modification en masse des p\u00e9riodes de cotisation associ\u00e9es aux contrats";
        this.setHeight("100%");
        this.setWidth(100);
    }

    @Override
    protected void addFields() {
        this.lines = new GestionContratService().getModeleContratInfo(EtatModeleContrat.CREATION, EtatModeleContrat.ACTIF, EtatModeleContrat.ARCHIVE);
        this.sortMode = SortMode.DATE;
        this.sortLines();
        if (this.lines.size() == 0) {
            this.addHtml("Il n'y a pas de contrats \u00e0 modifier");
            this.setWidth(60);
            return;
        }
        this.builder = new ComplexTableBuilder<ModeleContratSummaryDTO>(this.lines);
        this.builder.addString("Etat", false, 100, e -> e.etat);
        this.builder.addString("Nom", false, 300, e -> e.nom);
        this.builder.addString("Producteur", false, 300, e -> e.nomProducteur);
        this.builder.addString("Premi\u00e8re livraison", false, 100, e -> this.df.format(e.dateDebut));
        this.builder.addString("Derni\u00e8re livraison", false, 100, e -> this.df.format(e.dateFin));
        this.builder.addSearcher("P\u00e9riode de cotisation", "pc", true, 300, (T e) -> e.periodeCotisationId, new SDPeriodeCotisation());
        this.builder.setPageLength(12);
        this.addComplexTable(this.builder);
    }

    private void sortLines() {
        if (this.sortMode == SortMode.NOM) {
            CollectionUtils.sort(this.lines, e -> e.nom);
        } else {
            CollectionUtils.sort(this.lines, e -> e.dateFin, false, e -> e.nom, true);
        }
    }

    @Override
    protected void createButtonBar() {
        this.tri = this.addButton("Trier par nom", (Button.ClickListener & Serializable)e -> this.handleTri());
        super.createButtonBar();
    }

    private void handleTri() {
        this.sortMode = this.sortMode.toogle();
        this.tri.setCaption(this.sortMode == SortMode.DATE ? "Trier par nom" : "Trier par date");
        this.writeToModel();
        this.sortLines();
        this.builder.reload(this.lines);
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        this.writeToModel();
        new GestionContratService().updatePeriodeCotisationMasse(this.lines);
    }

    private void writeToModel() {
        int i = 0;
        while (i < this.lines.size()) {
            ModeleContratSummaryDTO line = this.lines.get(i);
            ComboBox cb = (ComboBox)this.builder.getComponent(i, "pc");
            line.periodeCotisationId = (Long)cb.getValue();
            ++i;
        }
    }

    public static enum SortMode {
        DATE,
        NOM;


        SortMode toogle() {
            if (this == DATE) {
                return NOM;
            }
            return DATE;
        }
    }
}

