/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes;

import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.model.models.param.paramecran.PEGestionContratsSignes;
import fr.amapj.service.services.gestioncontratsigne.ContratSigneDTO;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.cascadingpopup.CInfo;
import fr.amapj.view.engine.popup.cascadingpopup.CascadingData;
import fr.amapj.view.engine.popup.cascadingpopup.CascadingPopup;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.engine.popup.swicthpopup.SwitchPopup;
import fr.amapj.view.views.common.contratselector.ContratSelectorPart;
import fr.amapj.view.views.common.contrattelecharger.TelechargerContrat;
import fr.amapj.view.views.gestioncontratsignes.PopupCopyAllMailForContrat;
import fr.amapj.view.views.gestioncontratsignes.PopupSaisieUtilisateur;
import fr.amapj.view.views.gestioncontratsignes.modifiermasse.ModifierEnMasseContratSigne;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.stock.GestionContratStockPart;
import java.util.List;

public class GestionContratSignesListPart
extends StandardListPart<ContratSigneDTO> {
    private ContratSelectorPart contratSelectorPart;
    private PEGestionContratsSignes peEcran = (PEGestionContratsSignes)new ParametresService().loadParamEcran(MenuList.GESTION_CONTRAT_SIGNES);

    public GestionContratSignesListPart() {
        super(ContratSigneDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des contrats sign\u00e9s";
    }

    @Override
    protected void drawButton() {
        this.addButtonAction("Ajouter un contrat sign\u00e9", ButtonType.ALWAYS, () -> this.handleAjouter());
        this.addButtonAction("Visualiser", ButtonType.EDIT_MODE, () -> this.handleVoir());
        this.addButtonAction("Modifier les quantit\u00e9s", ButtonType.EDIT_MODE, () -> this.handleEditer());
        this.addButtonAction("Modifier les ch\u00e8ques", ButtonType.EDIT_MODE, () -> this.handleModifierCheque());
        this.addButtonAction("Supprimer", ButtonType.EDIT_MODE, () -> this.handleSupprimer());
        this.addButton("Modifier en masse ...", ButtonType.ALWAYS, e -> this.handleModifMasse());
        if (new ParametresService().getParametres().etatGestionStock == EtatModule.ACTIF) {
            this.addButton("Stock", ButtonType.ALWAYS, e -> GestionContratStockPart.handleStock(this.contratSelectorPart.getModeleContratId()));
        }
        this.addButton("Autre...", ButtonType.ALWAYS, e -> this.handleMore());
        this.addButton("T\u00e9l\u00e9charger ...", ButtonType.ALWAYS, e -> this.handleTelecharger());
        this.addSearchField("Rechercher par nom ou pr\u00e9nom");
    }

    @Override
    protected void addSelectorComponent() {
        this.contratSelectorPart = new ContratSelectorPart(this, true);
        HorizontalLayout toolbar1 = this.contratSelectorPart.getChoixContratComponent();
        this.addComponent((Component)toolbar1);
        this.contratSelectorPart.fillAutomaticValues();
    }

    @Override
    protected void drawTable() {
        this.addColumn("nomUtilisateur", "Nom");
        this.addColumn("prenomUtilisateur", "Pr\u00e9nom");
        this.addColumnDateTime("dateCreation", "Date cr\u00e9ation");
        this.addColumnDateTime("dateModification", "Date modification");
        this.addColumn("retardataire", "Retardataire");
        this.addColumnCurrency("mntCommande", "Command\u00e9(en \u20ac)").right();
    }

    @Override
    protected List<ContratSigneDTO> getLines() {
        Long idModeleContrat = this.contratSelectorPart.getModeleContratId();
        if (idModeleContrat == null) {
            return null;
        }
        return new GestionContratSigneService().getAllContratSigne(idModeleContrat);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nomUtilisateur", "prenomUtilisateur"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nomUtilisateur", "prenomUtilisateur"};
    }

    private CorePopup handleModifMasse() {
        Long idModeleContrat = this.contratSelectorPart.getModeleContratId();
        return ModifierEnMasseContratSigne.createPopup(idModeleContrat);
    }

    private SwitchPopup handleMore() {
        Long idModeleContrat = this.contratSelectorPart.getModeleContratId();
        SwitchPopup popup = new SwitchPopup("Autres actions sur les contrats sign\u00e9s", 50);
        popup.addLine("Envoyer un e mail \u00e0 tous les adh\u00e9rents de ce contrat", () -> new PopupCopyAllMailForContrat(idModeleContrat));
        return popup;
    }

    private CorePopup handleTelecharger() {
        Long idModeleContrat = this.contratSelectorPart.getModeleContratId();
        ContratSigneDTO contratSigneDTO = (ContratSigneDTO)this.getSelectedLine();
        Long idContrat = null;
        if (contratSigneDTO != null) {
            idContrat = contratSigneDTO.idContrat;
        }
        return TelechargerContrat.displayPopupTelechargerContrat(idModeleContrat, idContrat);
    }

    private void handleVoir() {
        ContratSigneDTO c = (ContratSigneDTO)this.getSelectedLine();
        String message = "Visualisation du contrat de " + c.prenomUtilisateur + " " + c.nomUtilisateur;
        SaisieContrat.saisieContrat(c.idModeleContrat, c.idContrat, c.idUtilisateur, message, SaisieContrat.ModeSaisie.READ_ONLY, this);
    }

    private void handleEditer() {
        ContratSigneDTO c = (ContratSigneDTO)this.getSelectedLine();
        String message = "Contrat de " + c.prenomUtilisateur + " " + c.nomUtilisateur;
        SaisieContrat.saisieContrat(c.idModeleContrat, c.idContrat, c.idUtilisateur, message, SaisieContrat.ModeSaisie.QTE_SEUL, this);
    }

    private void handleModifierCheque() {
        ContratSigneDTO c = (ContratSigneDTO)this.getSelectedLine();
        String message = "Modification des ch\u00e8ques de " + c.prenomUtilisateur + " " + c.nomUtilisateur;
        SaisieContrat.saisieContrat(c.idModeleContrat, c.idContrat, c.idUtilisateur, message, SaisieContrat.ModeSaisie.CHEQUE_SEUL, this);
    }

    private void handleSupprimer() {
        ContratSigneDTO contratSigneDTO = (ContratSigneDTO)this.getSelectedLine();
        String text = "Etes vous s\u00fbr de vouloir supprimer le contrat de " + contratSigneDTO.prenomUtilisateur + " " + contratSigneDTO.nomUtilisateur + " ?";
        SuppressionPopup confirmPopup = new SuppressionPopup(text, contratSigneDTO.idContrat, e -> new MesContratsService().deleteContrat((Long)e));
        confirmPopup.open(this);
    }

    private void handleAjouter() {
        AjouterData data = new AjouterData();
        data.idModeleContrat = this.contratSelectorPart.getModeleContratId();
        CascadingPopup cascading = new CascadingPopup(this, data);
        CInfo info = new CInfo();
        info.popup = new PopupSaisieUtilisateur(data, this.peEcran);
        info.onSuccess = () -> this.successSaisieUtilisateur(data);
        cascading.start(info);
    }

    private CInfo successSaisieUtilisateur(AjouterData data) {
        Long userId = data.userId;
        String message = "Contrat de " + new UtilisateurService().prettyString(userId);
        SaisieContrat.saisieContrat(data.idModeleContrat, null, userId, message, SaisieContrat.ModeSaisie.QTE_CHEQUE_REFERENT, this);
        return null;
    }

    public class AjouterData
    extends CascadingData {
        Long idModeleContrat;
        Long userId;
    }
}

