/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes;

import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.CollectionUtils;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import java.io.Serializable;
import java.util.List;

public class PopupCopyAllMailForContrat
extends CorePopup {
    private Long idModeleContrat;

    public PopupCopyAllMailForContrat(Long idModeleContrat) {
        this.popupTitle = "Comment envoyer un mail \u00e0 tous les amapiens de ce contrat ? ";
        this.setWidth(60);
        this.setHeight("90%");
        this.idModeleContrat = idModeleContrat;
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addDefaultButton("OK", (Button.ClickListener & Serializable)e -> this.close());
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        List<String> mails = new GestionContratSigneService().getAllMails(this.idModeleContrat);
        String msg = "Pour envoyer un mail \u00e0 tous adh\u00e9rents de ce contrat , vous devez :<br/><ul><li>Faire un copier de toutes les adresses e-mail en faisant Ctrl+C ou en faisant clic droit + Copier sur la zone bleue ci dessous</li><li>Ouvrir votre outil favori pour l'envoi des mails (Thunderbird, Gmail, Outlook, ...)</li><li>Faire nouveau message</li><li>Faire un coller de toutes les adresses e-mail en faisant Ctrl+V ou en faisant clic droit + Coller dans la liste des destinataires du message.</li></ul>";
        HorizontalLayout hlTexte = new HorizontalLayout();
        hlTexte.setMargin(true);
        hlTexte.setSpacing(true);
        hlTexte.setWidth("100%");
        Label textArea = new Label(msg, ContentMode.HTML);
        textArea.setStyleName("big");
        textArea.setWidth("80%");
        hlTexte.addComponent((Component)textArea);
        hlTexte.setExpandRatio((Component)textArea, 1.0f);
        hlTexte.setComponentAlignment((Component)textArea, Alignment.MIDDLE_CENTER);
        contentLayout.addComponent((Component)hlTexte);
        hlTexte = new HorizontalLayout();
        hlTexte.setMargin(true);
        hlTexte.setSpacing(true);
        hlTexte.setWidth("100%");
        TextArea listeMails = new TextArea("");
        listeMails.setValue(CollectionUtils.asString(mails, ","));
        listeMails.setReadOnly(true);
        listeMails.selectAll();
        listeMails.setWidth("80%");
        listeMails.setHeight(5.0f, Sizeable.Unit.CM);
        hlTexte.addComponent((Component)listeMails);
        hlTexte.setExpandRatio((Component)listeMails, 1.0f);
        hlTexte.setComponentAlignment((Component)listeMails, Alignment.MIDDLE_CENTER);
        contentLayout.addComponent((Component)hlTexte);
    }
}

