/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.date;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.service.services.gestioncontrat.DateModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.gestioncontratsigne.update.GestionContratSigneUpdateService;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionNoDuplicates;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionNotIn;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionSizeValidator;
import fr.amapj.view.engine.popup.formpopup.validator.ColumnNotNull;
import java.util.Date;
import java.util.List;

public class PopupAjoutDateLivraison
extends WizardFormPopup {
    private ModeleContratDTO modeleContratDTO;
    private List<Date> existingDateLivs;

    public PopupAjoutDateLivraison(Long id) {
        this.popupTitle = "Ajouter des dates de livraison \u00e0 un contrat";
        this.setWidth(80);
        this.modeleContratDTO = new GestionContratService().loadModeleContrat(id);
        this.existingDateLivs = CollectionUtils.select(this.modeleContratDTO.dateLivs, e -> e.dateLiv);
        this.modeleContratDTO.dateLivs.clear();
        this.setModel(this.modeleContratDTO);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.saisieDate());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va vous permettre d'ajouter une ou plusieurs dates de livraison, pour tous les adh\u00e9rents \u00e0 ce contrat.</br><br/>Par contre, cet outil ne modifie pas les quantit\u00e9s command\u00e9es. Vous devez ensuite ajouter manuellement les bonnes quantit\u00e9s sur les nouvelles dates.<br/>Il faut ensuite \u00e9galement mettre \u00e0 jour les paiements manuellement.<br/>";
        this.addHtml(str);
    }

    private void saisieDate() {
        this.setStepTitle("les dates \u00e0 ajouter");
        CollectionSizeValidator size = new CollectionSizeValidator(1, null);
        CollectionNoDuplicates<DateModeleContratDTO> noDuplicates = new CollectionNoDuplicates<DateModeleContratDTO>(e -> e.dateLiv);
        CollectionNotIn<DateModeleContratDTO, Date> notIn = new CollectionNotIn<DateModeleContratDTO, Date>(e -> e.dateLiv, this.existingDateLivs, e -> "Vous ne pouvez pas ajouter la date " + FormatUtils.getStdDate().format(e.dateLiv) + " car c'est d\u00e9j\u00e0 une date livraison de ce contrat.");
        this.addCollectionEditorField("Liste des dates", "dateLivs", DateModeleContratDTO.class, size, noDuplicates, notIn);
        this.addColumn("dateLiv", "Date", FieldType.DATE, null, new ColumnNotNull<DateModeleContratDTO>(e -> e.dateLiv));
    }

    @Override
    protected void performSauvegarder() {
        new GestionContratSigneUpdateService().addDates(this.modeleContratDTO);
    }
}

