/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.date;

import fr.amapj.common.DateUtils;
import fr.amapj.service.services.gestioncontratsigne.DeplacerDateLivraisonDTO;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PopupDeplacerDateLivraison
extends WizardFormPopup {
    private DeplacerDateLivraisonDTO deplacerDto;

    public PopupDeplacerDateLivraison(Long mcId) {
        this.setWidth(80);
        this.popupTitle = "D\u00e9placer une date de livraison";
        this.deplacerDto = new GestionContratSigneService().getDeplacerDateLivraisonDTO(mcId);
        this.setModel(this.deplacerDto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldSaisieDate());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va vous permettre de d\u00e9placer une date de livraison, pour tous les adh\u00e9rents \u00e0 ce contrat</br><br/>Exemple de cas d'utilisation : un producteur a pr\u00e9vu de livrer ses produits le 20 janvier<br/>Il est oblig\u00e9 de d\u00e9caler au 27 janvier pour une raison quelconque.<br/>Cet outil permet de d\u00e9placer la date, en gardant \u00e0 l'identique les quantit\u00e9s command\u00e9es<br/><br/><br/>Cet outil affiche la liste des e mails des personnes impact\u00e9es, vous pourrez alors les avertir.<br/>";
        this.addHtml(str);
    }

    private void addFieldSaisieDate() {
        this.setStepTitle("le choix de la date \u00e0 d\u00e9placer");
        SimpleDateFormat df = new SimpleDateFormat("EEEEE dd/MM/yyyy");
        this.addGeneralComboField("La date \u00e0 d\u00e9placer", this.deplacerDto.dateLivraisonDTOs, "selected", e -> df.format(e.dateLiv), new IValidator[0]);
        this.addDateField("La nouvelle date", "actualDate", new NotNullValidator());
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation");
        if (this.isModifPossible()) {
            String info = new GestionContratSigneService().getDeplacerInfo(this.deplacerDto.selected.idModeleContratDate);
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            String str = "La livraison du " + df.format(this.deplacerDto.selected.dateLiv) + " va \u00eatre d\u00e9plac\u00e9e au " + df.format(this.deplacerDto.actualDate) + ".";
            this.addHtml(str);
            this.addHtml(info);
            this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
        } else {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            String str = "La nouvelle date de livraison " + df.format(this.deplacerDto.actualDate) + " est d\u00e9j\u00e0 une date de livraison pour ce contrat.";
            this.addHtml("Cette modification est impossible.");
            this.addHtml(str);
            this.addHtml("Appuyez sur Etape pr\u00e9c\u00e9dente pour modifier votre choix, ou Annuler pour abandonner");
        }
    }

    private boolean isModifPossible() {
        Date ref = DateUtils.suppressTime(this.deplacerDto.actualDate);
        for (DeplacerDateLivraisonDTO.ModifDateLivraisonDTO md : this.deplacerDto.dateLivraisonDTOs) {
            if (!md.dateLiv.equals(ref)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void performSauvegarder() {
        if (this.isModifPossible()) {
            new GestionContratSigneService().performDeplacerDateLivraison(this.deplacerDto);
        }
    }
}

