/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.date;

import com.vaadin.ui.CheckBox;
import fr.amapj.common.FormatUtils;
import fr.amapj.service.services.gestioncontratsigne.update.GestionContratSigneUpdateService;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupSupprimerDateLivraison
extends WizardFormPopup {
    private ContratDTO contratDTO;
    private List<ContratLigDTO> datesBarrees;
    private ComplexTableBuilder<ContratLigDTO> builder;
    private List<ContratLigDTO> modeleContratDateToDebarrer;
    private Long idModeleContrat;

    public PopupSupprimerDateLivraison(Long idModeleContrat) {
        this.idModeleContrat = idModeleContrat;
        this.setWidth(80);
        this.popupTitle = "Supprimer une ou plusieurs dates de livraison";
        this.contratDTO = new MesContratsService().loadContrat(idModeleContrat, null);
        this.datesBarrees = this.contratDTO.computeDateBarrees();
        this.modeleContratDateToDebarrer = new ArrayList<ContratLigDTO>();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales(), () -> this.checkDateBarrees());
        this.add(() -> this.addFieldSaisieDate(), () -> this.readDateToDebarrer());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va vous permettre de supprimer d\u00e9finitivement une date de livraison.<br/>Pour pouvoir supprimer une date de livraison, vous devez d'abord barrer la date, en faisant \"Modifier en masse\" puis \"Barrer une ou plusieurs dates de livraison\".<br/>";
        this.addHtml(str);
    }

    private String checkDateBarrees() {
        if (this.datesBarrees.size() == 0) {
            return "Il n'y a pas de dates barr\u00e9es sur ce contrat. Vous ne pouvez donc pas continuer.";
        }
        return null;
    }

    private void addFieldSaisieDate() {
        this.setStepTitle("les dates barr\u00e9es \u00e0 supprimer d\u00e9finitivement");
        String str = "Veuillez indiquer les dates que vous souhaitez supprimer : </br>";
        this.addHtml(str);
        this.builder = new ComplexTableBuilder<ContratLigDTO>(this.datesBarrees);
        this.builder.setPageLength(7);
        this.builder.addDate("Date", false, 300, e -> e.date);
        this.builder.addCheckBox("Supprimer cette date", "cb", true, 150, e -> this.modeleContratDateToDebarrer.contains(e.modeleContratDateId), null);
        this.addComplexTable(this.builder);
    }

    private String readDateToDebarrer() {
        this.modeleContratDateToDebarrer.clear();
        int i = 0;
        while (i < this.datesBarrees.size()) {
            ContratLigDTO lig = this.datesBarrees.get(i);
            CheckBox cb = (CheckBox)this.builder.getComponent(i, "cb");
            if (((Boolean)cb.getValue()).booleanValue()) {
                this.modeleContratDateToDebarrer.add(lig);
            }
            ++i;
        }
        if (this.modeleContratDateToDebarrer.size() == 0) {
            return "Vous devez choisir au moins une date pour pouvoir continuer.";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation avant modification");
        this.addHtml("Vous allez supprimer d\u00e9finitivement  " + this.modeleContratDateToDebarrer.size() + " dates de ce contrat:");
        this.addHtml(FormatUtils.puceDate(this.modeleContratDateToDebarrer, e -> e.date));
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        new GestionContratSigneUpdateService().suppressManyDateLivs(this.modeleContratDateToDebarrer, this.idModeleContrat);
    }
}

