/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.docengagement;

import com.vaadin.ui.ComboBox;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.engine.metadata.MetaDataEnum;
import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineDTO;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineService;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.fieldlink.FieldLink;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.views.searcher.SearcherList;
import java.util.Arrays;
import java.util.List;

public class PopupModifGestionDocEngagementWithExistingContrat
extends WizardFormPopup {
    private ModeleContratDTO modeleContrat;
    private GestionDocEngagement currentGestionDocEngagement;
    private Long currentIdEngagement;

    @Override
    protected void configure() {
        this.add(() -> this.drawIntro());
        this.add(() -> this.drawChoixAction(), () -> this.checkChoixAction());
    }

    public PopupModifGestionDocEngagementWithExistingContrat(Long id) {
        this.popupTitle = "Modification de la gestion des documents d'engagement";
        this.setWidth(80);
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        this.setModel(this.modeleContrat);
        this.currentGestionDocEngagement = this.modeleContrat.gestionDocEngagement;
        this.currentIdEngagement = this.modeleContrat.idEngagement;
    }

    private void drawIntro() {
        this.setStepTitle("Introduction");
        this.addText("Cet outil permet de modifier les r\u00e9gles de gestion des documents d'engagement pour ce contrat.");
        this.addText("L'outil vous guidera pas \u00e0 pas et vous indiquera \u00e0 l'avance les op\u00e9rations qui seront r\u00e9alis\u00e9es.");
        MetaDataEnum.HelpInfo m = MetaDataEnum.getHelpInfo(GestionDocEngagement.class);
        this.addText("Vous allez modifier le contrat " + this.modeleContrat.nom + ", pour l'instant ce contrat utilise la r\u00e9gle de gestion :  " + m.getLib(this.modeleContrat.gestionDocEngagement));
        this.addHtml(m.getAide(this.modeleContrat.gestionDocEngagement));
    }

    private void drawChoixAction() {
        this.setStepTitle("Saisie de la nouvelle r\u00e9gle de gestion des documents d'engagement pour ce contrat");
        ComboBox b1 = this.addComboEnumField("Gestion des documents d'engagement", "gestionDocEngagement", new NotNullValidator());
        FieldLink f1 = new FieldLink(this.validatorManager, Arrays.asList(new Enum[]{GestionDocEngagement.SIGNATURE_EN_LIGNE, GestionDocEngagement.GENERATION_DOCUMENT_SEUL}), b1, true);
        f1.addField(this.addSearcher("Document d'engagement (\u00e0 signer) ", "idEngagement", SearcherList.ENGAGEMENT, null, f1.getValidator()));
        f1.doLink();
    }

    private String checkChoixAction() {
        switch (this.modeleContrat.gestionDocEngagement) {
            case AUCUNE_GESTION: {
                switch (this.currentGestionDocEngagement) {
                    case GENERATION_DOCUMENT_SEUL: {
                        return null;
                    }
                    case SIGNATURE_EN_LIGNE: {
                        return this.checkNoDocs();
                    }
                    case AUCUNE_GESTION: {
                        return null;
                    }
                }
                throw new AmapjRuntimeException();
            }
            case GENERATION_DOCUMENT_SEUL: {
                switch (this.currentGestionDocEngagement) {
                    case AUCUNE_GESTION: {
                        return null;
                    }
                    case SIGNATURE_EN_LIGNE: {
                        return this.checkNoDocs();
                    }
                    case GENERATION_DOCUMENT_SEUL: {
                        return null;
                    }
                }
                throw new AmapjRuntimeException();
            }
            case SIGNATURE_EN_LIGNE: {
                switch (this.currentGestionDocEngagement) {
                    case AUCUNE_GESTION: {
                        return null;
                    }
                    case GENERATION_DOCUMENT_SEUL: {
                        return null;
                    }
                    case SIGNATURE_EN_LIGNE: {
                        if (this.currentIdEngagement.equals(this.modeleContrat.idEngagement)) {
                            return null;
                        }
                        return this.checkNoDocs();
                    }
                }
                throw new AmapjRuntimeException();
            }
        }
        throw new AmapjRuntimeException();
    }

    private String checkNoDocs() {
        List<DocEngagementSignOnLineDTO> docs = new DocEngagementSignOnLineService().getBilanSignature(this.modeleContrat.id);
        long nbDocSignes = docs.stream().filter(e -> e.signedByAmapien != null).count();
        if (nbDocSignes == 0L) {
            return null;
        }
        return "Cette op\u00e9ration est impossible car ce contrat comprend " + nbDocSignes + " documents d'engagement d\u00e9j\u00e0 sign\u00e9s en ligne. Vous devez d'abord les supprimer en allant dans \"Gestion des contrats sign\u00e9s\", puis \"Modifier en masse\" puis \"Supprimer tous les documents d'engagement d\u00e9j\u00e0 sign\u00e9s en ligne\".";
    }

    @Override
    protected void performSauvegarder() {
        new GestionContratService().updateSignatureEnLigne(this.modeleContrat);
    }
}

