/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.docengagement;

import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineDTO;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineService;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import java.util.List;

public class PopupSuppressAllDocEngagement
extends WizardFormPopup {
    private ModeleContratDTO modeleContrat;
    private TextField tf;
    private long nbDocSigneAmapien;

    @Override
    protected void configure() {
        this.add(() -> this.drawIntro());
        this.add(() -> this.drawPerformAction(), () -> this.checkPerformAction());
        this.add(() -> this.drawBilan());
    }

    public PopupSuppressAllDocEngagement(Long id) {
        this.popupTitle = "Suppression des documents d'engagement d\u00e9j\u00e0 sign\u00e9s";
        this.setWidth(80);
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        List<DocEngagementSignOnLineDTO> docs = new DocEngagementSignOnLineService().getBilanSignature(id);
        this.nbDocSigneAmapien = docs.stream().filter(e -> e.signedByAmapien != null).count();
    }

    @Override
    protected String checkInitialCondition() {
        if (this.nbDocSigneAmapien == 0L) {
            return "Ce contrat n'a pas de document d'engagement d\u00e9j\u00e0 sign\u00e9";
        }
        return null;
    }

    private void drawIntro() {
        this.setStepTitle("Introduction");
        this.addText("vous allez modifier le contrat " + this.modeleContrat.nom + ", qui utilise la signature en ligne des documents d'engagement.");
        this.addText("Cet outil permet de supprimer tous les documents d'engagement d\u00e9j\u00e0 sign\u00e9s.");
        this.addText("Par contre, les donn\u00e9es des contrats souscrits (quantit\u00e9, paiement) seront bien conserv\u00e9es.");
        this.addText("Une fois les documents d'engagement supprim\u00e9s, les amapiens pourront les signer de nouveau en allant dans l'\u00e9cran \"Mes contrats\", en cliquant juste sur \"Signer\", sans avoir \u00e0 ressaisir les quantit\u00e9s.");
        this.addText("Cet outil doit \u00eatre utilis\u00e9 par exemple quand vous constatez une erreur importante dans les documents d'engagements d\u00e9j\u00e0 sign\u00e9s, et vous souhaitez donc les refaire signer avec le bon document.");
    }

    private void drawPerformAction() {
        this.setStepTitle("Confirmation");
        this.addText("Le contrat " + this.modeleContrat.nom + " comprend " + this.nbDocSigneAmapien + " documents d'engagement d\u00e9j\u00e0 sign\u00e9s en ligne.");
        this.addText("Vous allez d'effacer de fa\u00e7on d\u00e9finitive ces documents d'engagement.");
        this.addHtml("Si vous souhaitez continuer, vous devez saisir ci dessous le texte <br/>JE CONFIRME<br/> puis cliquer sur Continuer");
        this.tf = new TextField("");
        this.tf.setValue("");
        this.tf.setImmediate(true);
        this.form.addComponent((Component)this.tf);
    }

    private String checkPerformAction() {
        if (((String)this.tf.getValue()).equals("JE CONFIRME")) {
            return null;
        }
        return "Pour pouvoir continuer, vous devez saisir le texte JE CONFIRME";
    }

    private void drawBilan() {
        this.setAllButtonsAsOK();
        String res = new DocEngagementSignOnLineService().deleteAllDocEngagement(this.modeleContrat);
        this.setStepTitle("bilan");
        this.addText("Les documents d'engagement ont \u00e9t\u00e9 supprim\u00e9s et pourront \u00eatre sign\u00e9s de nouveau.");
        this.addHtml(res);
    }

    @Override
    protected void performSauvegarder() {
    }
}

