/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.paiement;

import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.mespaiements.PaiementService;
import fr.amapj.view.views.gestioncontrat.editorpart.GestionContratEditorPart;
import fr.amapj.view.views.gestioncontrat.editorpart.utils.GestionContratPaiementUtils;

public class PopupDesactiverSuiviPaiement
extends GestionContratEditorPart {
    private int nbInscrits;
    private TextField tf;

    public PopupDesactiverSuiviPaiement(Long id) {
        this.setWidth(80);
        this.popupTitle = "Supprimer le suivi des paiements pour un contrat";
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        new GestionContratPaiementUtils().checkAndUpdateStrategieAndSaisiePaiementCalculDate(this.modeleContrat);
        this.setModel(this.modeleContrat);
        if (this.modeleContrat.gestionPaiement == GestionPaiement.NON_GERE) {
            throw new AmapjRuntimeException();
        }
        this.nbInscrits = new GestionContratService().getNbInscrits(id);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addIntro());
        this.add(() -> this.addStep2(), () -> this.checkStep2());
        this.add(() -> this.addStep3());
    }

    private void addIntro() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Le suivi des paiements est activ\u00e9 pour ce contrat pour le moment. En continuant, vous allez SUPPRIMER toutes les informations relatives au paiement<br/><br/>" + this.nbInscrits + " adh\u00e9rents ont d\u00e9j\u00e0 souscrits \u00e0 ce contrat, TOUTES LES INFORMATIONS DE PAIEMENT SERONT EFFACEES<br/>" + " Cliquer sur Continuer pour confirmer cette suppression";
        this.addHtml(str);
    }

    private void addStep2() {
        this.setStepTitle("confirmation");
        boolean b = new PaiementService().canSuppressPaiementModeleContrat(this.modeleContrat.id);
        if (!b) {
            this.addHtml("Ce contrat contient des ch\u00e8ques \u00e0 l'\u00e9tat AMAP ou PRODUCTEUR. Il faut supprimer d'abord tous ces ch\u00e8ques pour pouvoir continuer.");
            this.setBackOnlyMode();
            return;
        }
        this.addHtml("Vous allez effacer toutes les informations de paiements. Si vous souhaitez continuer, vous devez saisir ci dessous le texte <br/>JE CONFIRME<br/> puis cliquer sur Continuer");
        this.tf = new TextField("");
        this.tf.setValue("");
        this.tf.setImmediate(true);
        this.form.addComponent((Component)this.tf);
    }

    private String checkStep2() {
        if (((String)this.tf.getValue()).equals("JE CONFIRME")) {
            return null;
        }
        return "Pour pouvoir continuer, vous devez saisir le texte JE CONFIRME";
    }

    private void addStep3() {
        this.modeleContrat.gestionPaiement = GestionPaiement.NON_GERE;
        this.drawDetailPaiement(true);
    }

    @Override
    protected void performSauvegarder() {
        new PaiementService().deleteInfoPaiement(this.modeleContrat);
    }

    @Override
    protected String checkInitialCondition() {
        if (this.nbInscrits == 0) {
            String str = "Aucun adh\u00e9rent n'est inscrit \u00e0 ce contrat. Vous pouvez donc modifier les r\u00e8gles de paiements librement, en allant dans \"Gestion des contrats vierges\", puis vous cliquez sur le bouton \"Modifier\" puis \"les informations de paiements\"<br/>";
            return str;
        }
        return null;
    }
}

