/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.produit;

import com.vaadin.ui.Component;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.LigneContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.views.searcher.SDProduit;
import fr.amapj.view.views.searcher.SearcherList;

public class PopupProduitOrdreContrat
extends WizardFormPopup {
    private ModeleContratDTO modeleContrat;

    public PopupProduitOrdreContrat(Long mcId) {
        this.setWidth(80);
        this.popupTitle = "Ordre des produits dans un contrat";
        this.modeleContrat = new GestionContratService().loadModeleContrat(mcId);
        this.setModel(this.modeleContrat);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldOrdreProduit());
    }

    private void addFieldOrdreProduit() {
        this.setStepTitle("changer l'ordre des produits");
        Searcher prod = new Searcher(SearcherList.PRODUCTEUR);
        prod.bind(this.binder, "producteur");
        this.form.addComponent((Component)prod);
        prod.setEnabled(false);
        CollectionEditor<LigneContratDTO> f1 = this.addCollectionEditorField("Produits", "produits", LigneContratDTO.class, new IValidator[0]);
        f1.addSearcherColumn("produitId", "Nom du produit", FieldType.SEARCHER, false, null, new SDProduit(prod), prod);
        f1.addColumn("prix", "Prix du produit", FieldType.CURRENCY, false, null);
        f1.addBeanIdToPreserve("idModeleContratProduit");
        f1.activeButton(false, false, true, true);
    }

    @Override
    protected void performSauvegarder() {
        new GestionContratSigneService().performModifProduitOrdreContrat(this.modeleContrat);
    }
}

