/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.produit;

import com.vaadin.ui.CheckBox;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.LigneContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupProduitSuppression
extends WizardFormPopup {
    private ModeleContratDTO modeleContrat;
    private ComplexTableBuilder<LigneContratDTO> builder;
    private List<Long> modeleContratProduitsToSuppress;

    public PopupProduitSuppression(Long mcId) {
        this.setWidth(80);
        this.popupTitle = "Suppression des produits d'un contrat";
        this.modeleContrat = new GestionContratService().loadModeleContrat(mcId);
        this.modeleContratProduitsToSuppress = new ArrayList<Long>();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldSaisiePrix(), () -> this.readProduitsToSuppress());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        String str;
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        int nbInscrits = new GestionContratService().getNbInscrits(this.modeleContrat.id);
        if (nbInscrits == 0) {
            str = "Aucun adh\u00e9rent n'est inscrit \u00e0 ce contrat. Vous pouvez donc supprimer les prdouits librement.";
        } else {
            str = nbInscrits + " adh\u00e9rents ont d\u00e9j\u00e0 souscrits \u00e0 ce contrat.<br/>" + "La suppression d'un produit peut donc modifier le prix total du contrat pour ces adh\u00e9rents.<br/><br/>" + "Une fois que vous aurez supprim\u00e9 des produits, le programme vous affichera la liste des adh\u00e9rents impact\u00e9s pour que vous puissiez les pr\u00e9venir.<br/>";
            if (this.modeleContrat.gestionPaiement != GestionPaiement.NON_GERE) {
                str = String.valueOf(str) + "Il faudra \u00e9galement modifier les paiements manuellement pour compenser l'\u00e9cart de prix ou g\u00e9rer un avoir en fin de contrat.<br/>.";
            }
        }
        this.addHtml(str);
    }

    private void addFieldSaisiePrix() {
        this.setStepTitle("les produits \u00e0 supprimer");
        this.builder = new ComplexTableBuilder<LigneContratDTO>(this.modeleContrat.produits);
        this.builder.setPageLength(7);
        this.builder.addString("Nom du produit", false, 300, e -> e.produitNom);
        this.builder.addString("Conditionnement", false, 300, e -> e.produitConditionnement);
        this.builder.addCheckBox("Supprimer ce produit", "cb", true, 150, e -> this.modeleContratProduitsToSuppress.contains(e.idModeleContratProduit), null);
        this.addComplexTable(this.builder);
    }

    private String readProduitsToSuppress() {
        this.modeleContratProduitsToSuppress.clear();
        int i = 0;
        while (i < this.modeleContrat.produits.size()) {
            LigneContratDTO lig = this.modeleContrat.produits.get(i);
            CheckBox cb = (CheckBox)this.builder.getComponent(i, "cb");
            if (((Boolean)cb.getValue()).booleanValue()) {
                this.modeleContratProduitsToSuppress.add(lig.idModeleContratProduit);
            }
            ++i;
        }
        if (this.modeleContratProduitsToSuppress.size() == 0) {
            return "Vous devez supprimer au moins un produit pour pouvoir continuer.";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation");
        String info = new GestionContratSigneService().getSuppressProduitInfo(this.modeleContrat.id, this.modeleContratProduitsToSuppress);
        this.addHtml(info);
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() {
        new GestionContratSigneService().performSupressProduit(this.modeleContrat.id, this.modeleContratProduitsToSuppress);
    }
}

