/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.historiquecontrats;

import fr.amapj.service.services.historiquecontrats.HistoriqueContratDTO;
import fr.amapj.service.services.historiquecontrats.HistoriqueContratsService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.util.List;

public class HistoriqueContratsView
extends StandardListPart<HistoriqueContratDTO> {
    public HistoriqueContratsView() {
        super(HistoriqueContratDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste de vos anciens contrats";
    }

    @Override
    protected void drawButton() {
        this.addButtonAction("Voir le d\u00e9tail", ButtonType.EDIT_MODE, () -> this.handleVoir());
        this.addSearchField("Rechercher par le producteur ou le nom du contrat");
    }

    @Override
    protected void drawTable() {
        this.addColumn("nomProducteur", "Producteur");
        this.addColumn("nomContrat", "Contrat");
        this.addColumnDate("dateDebut", "Premi\u00e8re livraison");
        this.addColumnDate("dateFin", "Derni\u00e8re livraison");
        this.addColumnDateTime("dateCreation", "Date cr\u00e9ation");
        this.addColumnDateTime("dateModification", "Date modification");
        this.addColumnCurrency("montant", "Montant (en \u20ac)").right();
    }

    @Override
    protected List<HistoriqueContratDTO> getLines() {
        return new HistoriqueContratsService().getHistoriqueContrats(SessionManager.getUserId());
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nomProducteur", "dateFin"};
    }

    @Override
    protected boolean[] getSortAsc() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        return blArray;
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nomProducteur", "nomContrat"};
    }

    private void handleVoir() {
        HistoriqueContratDTO c = (HistoriqueContratDTO)this.getSelectedLine();
        SaisieContrat.saisieContrat(c.idModeleContrat, c.idContrat, c.idUtilisateur, null, SaisieContrat.ModeSaisie.READ_ONLY, null);
    }
}

