/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.importdonnees;

import fr.amapj.common.StringUtils;
import fr.amapj.service.services.importdonnees.ImportDonneesService;
import fr.amapj.service.services.importdonnees.ImportProduitProducteurDTO;
import fr.amapj.view.views.importdonnees.tools.AbstractImporter;
import java.util.List;

public class ProduitImporter
extends AbstractImporter<ImportProduitProducteurDTO> {
    public ProduitImporter() {
        super(true);
    }

    @Override
    public int getNumCol() {
        return 4;
    }

    @Override
    public String getEntete(int indexCol) {
        if (indexCol == 0) {
            return "Producteur";
        }
        if (indexCol == 1) {
            return "Nom du produit";
        }
        if (indexCol == 2) {
            return "Conditionnement du produit";
        }
        if (indexCol == 3) {
            return "Description du produit";
        }
        return null;
    }

    @Override
    public List<ImportProduitProducteurDTO> getAllDataInDatabase() {
        List<ImportProduitProducteurDTO> existing = new ImportDonneesService().getAllProduits();
        return existing;
    }

    @Override
    public String checkBasic(ImportProduitProducteurDTO dto) {
        if (this.isEmpty(dto.produit)) {
            return "Le nom du produit n'est pas renseign\u00e9. Il est obligatoire.";
        }
        String msg = this.checkLength(dto.produit, 1, 255, "nom du produit");
        if (msg != null) {
            return msg;
        }
        if (this.isEmpty(dto.conditionnement)) {
            return "Le conditionnement du produit n'est pas renseign\u00e9. Il est obligatoire.";
        }
        msg = this.checkLength(dto.conditionnement, 1, 500, "conditionnement du produit");
        if (msg != null) {
            return msg;
        }
        if (this.isEmpty(dto.producteur)) {
            return "Le nom du producteur n'est pas renseign\u00e9. Il est obligatoire.";
        }
        msg = this.checkLength(dto.producteur, 1, 100, "nom du producteur");
        if (msg != null) {
            return msg;
        }
        return null;
    }

    @Override
    public ImportProduitProducteurDTO createDto(String[] strs) {
        ImportProduitProducteurDTO dto = new ImportProduitProducteurDTO();
        dto.producteur = strs[0];
        dto.produit = strs[1];
        dto.conditionnement = strs[2];
        dto.description = strs[3];
        return dto;
    }

    @Override
    public void saveInDataBase(List<ImportProduitProducteurDTO> prods) {
        new ImportDonneesService().insertDataProduits(prods);
    }

    @Override
    public String checkDifferent(ImportProduitProducteurDTO dto1, ImportProduitProducteurDTO dto2) {
        if (dto1.producteur.equalsIgnoreCase(dto2.producteur) && dto1.produit.equalsIgnoreCase(dto2.produit) && StringUtils.equalsIgnoreCase(dto1.conditionnement, dto2.conditionnement)) {
            return "Deux produits chez le m\u00eame producteur ont le m\u00eame nom et condtionnement alors que ceci est interdit.";
        }
        return null;
    }

    @Override
    public void dumpInfo(List<String> errorMessage, ImportProduitProducteurDTO dto) {
        errorMessage.add("Producteur:" + dto.producteur);
        errorMessage.add("Nom du produit:" + dto.produit);
        errorMessage.add("Conditionnement du produit:" + dto.conditionnement);
    }
}

