/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.importdonnees;

import fr.amapj.common.StringUtils;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.popup.formpopup.validator.EmailValidator;
import fr.amapj.view.views.importdonnees.tools.AbstractImporter;
import java.io.IOException;
import java.util.List;

public class UtilisateurImporter
extends AbstractImporter<UtilisateurDTO> {
    public UtilisateurImporter() {
        super(false);
    }

    @Override
    public int getNumCol() {
        return 8;
    }

    @Override
    public String getEntete(int indexCol) {
        if (indexCol == 0) {
            return "Nom";
        }
        if (indexCol == 1) {
            return "Pr\u00e9nom";
        }
        if (indexCol == 2) {
            return "E mail";
        }
        return null;
    }

    @Override
    public List<UtilisateurDTO> getAllDataInDatabase() {
        List<UtilisateurDTO> existing = new UtilisateurService().getAllUtilisateurs(null);
        return existing;
    }

    @Override
    public String checkBasic(UtilisateurDTO dto) {
        if (this.isEmpty(dto.nom)) {
            return "Le nom n'est pas renseign\u00e9. Il est obligatoire.";
        }
        if (this.isEmpty(dto.email)) {
            return "L'adresse e mail n'est pas renseign\u00e9e. Elle est obligatoire. Si la personne n'a pas d'email, merci de mettre son nom ou pr\u00e9nom suivi d'un #. Exemple : geraldine#";
        }
        if (!EmailValidator.isValidEmail(dto.email)) {
            return "L'adresse e mail n'est pas valide. Si la personne n'a pas d'email, merci de mettre son nom ou pr\u00e9nom suivi d'un #. Exemple : geraldine#";
        }
        return null;
    }

    @Override
    public UtilisateurDTO createDto(String[] strs) {
        UtilisateurDTO dto = new UtilisateurDTO();
        dto.nom = strs[0];
        dto.prenom = strs[1];
        dto.email = this.trimEmail(strs[2]);
        dto.numTel1 = strs[3];
        dto.numTel2 = strs[4];
        dto.libAdr1 = strs[5];
        dto.codePostal = strs[6];
        dto.ville = strs[7];
        return dto;
    }

    private String trimEmail(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    @Override
    public void saveInDataBase(List<UtilisateurDTO> utilisateurs) {
        new UtilisateurService().insertAllUtilisateurs(utilisateurs);
    }

    @Override
    public String checkDifferent(UtilisateurDTO dto1, UtilisateurDTO dto2) {
        if (dto1.email.equalsIgnoreCase(dto2.email)) {
            return "Deux utilisateurs ont la m\u00eame adresse e mail alors que ceci est interdit.";
        }
        if (dto1.nom.equalsIgnoreCase(dto2.nom) && StringUtils.equalsIgnoreCase(dto1.prenom, dto2.prenom)) {
            return "Deux utilisateurs ont le m\u00eame nom et pr\u00e9nom alors que ceci est interdit.";
        }
        return null;
    }

    @Override
    public void dumpInfo(List<String> errorMessage, UtilisateurDTO dto) {
        errorMessage.add("Nom:" + dto.nom);
        errorMessage.add("Pr\u00e9nom:" + dto.prenom);
        errorMessage.add("Email:" + dto.email);
        if (dto.etatUtilisateur == EtatUtilisateur.INACTIF) {
            errorMessage.add("Attention : cet utilisateur est \u00e0 l'\u00e9tat archiv\u00e9 (inactif)");
        }
    }

    public static void main(String[] args) throws IOException {
        UtilisateurImporter importer = new UtilisateurImporter();
        importer.test("c:\\tmp\\liste-adherents (8).xls");
    }
}

