/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.importdonnees.tools;

import com.vaadin.ui.Upload;
import fr.amapj.common.LongUtils;
import fr.amapj.common.StringUtils;
import fr.amapj.model.engine.tools.TestTools;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.tools.TableItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;

public abstract class AbstractImporter<T extends TableItem>
implements Upload.Receiver,
Upload.SucceededListener {
    private List<String> errorMessage = new ArrayList<String>();
    private ByteArrayOutputStream baos;
    private boolean allowUpdateOfExistingItem;

    public abstract void saveInDataBase(List<T> var1);

    public abstract T createDto(String[] var1);

    public abstract int getNumCol();

    public abstract String getEntete(int var1);

    public abstract List<T> getAllDataInDatabase();

    public abstract String checkBasic(T var1);

    public abstract String checkDifferent(T var1, T var2);

    public abstract void dumpInfo(List<String> var1, T var2);

    public AbstractImporter(boolean allowUpdateOfExistingItem) {
        this.allowUpdateOfExistingItem = allowUpdateOfExistingItem;
    }

    public OutputStream receiveUpload(String filename, String mimeType) {
        this.baos = new ByteArrayOutputStream();
        return this.baos;
    }

    public void uploadSucceeded(Upload.SucceededEvent event) {
        this.errorMessage.clear();
        try {
            this.processFile();
            if (this.errorMessage.size() == 0) {
                MessagePopup popup = new MessagePopup("Chargement effectu\u00e9", CorePopup.ColorStyle.GREEN, "Le chargement a \u00e9t\u00e9 effectu\u00e9");
                MessagePopup.open(popup);
            } else {
                MessagePopup popup = new MessagePopup("Erreur lors du chargement", this.errorMessage);
                MessagePopup.open(popup);
            }
        }
        catch (OfficeXmlFileException officeXmlFileException) {
            String str1 = "Le format de votre fichier est incorrect. Vous devez obligatoirement utiliser le format .xls (et non .xlsx)";
            String str2 = "Vous ouvrez votre fichier dans Excel ou dans Libre Office, et vous faites Sauvegarder sous et vous choisissez comme format \"Classeur Excel 97 -2003 (*.xls)\" ";
            new MessagePopup("Erreur dans le format du fichier", CorePopup.ColorStyle.RED, str1, str2).open();
        }
        catch (IOException e) {
            MessagePopup popup = new MessagePopup("Erreur lors du chargement", CorePopup.ColorStyle.RED, e.getMessage());
            MessagePopup.open(popup);
        }
    }

    private void processFile() throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new ByteArrayInputStream(this.baos.toByteArray()));
        DataFormatter df = new DataFormatter(Locale.FRANCE);
        HSSFSheet sheet = workbook.getSheetAt(0);
        int numCol = this.getNumCol();
        List<T> existing = this.getAllDataInDatabase();
        ArrayList<T> utilisateurs = new ArrayList<T>();
        int lastRowNum = sheet.getLastRowNum();
        this.checkEntete(sheet.getRow(2), numCol, df);
        if (this.errorMessage.size() != 0) {
            return;
        }
        int numLigne = 4;
        while (numLigne <= lastRowNum + 1) {
            HSSFRow row = sheet.getRow(numLigne - 1);
            String[] strs = new String[numCol];
            boolean isEmptyLine = true;
            int i = 0;
            while (i < strs.length) {
                strs[i] = this.getCell((Row)row, i, df);
                if (strs[i] != null && strs[i].length() > 0) {
                    strs[i] = strs[i].trim();
                    isEmptyLine = false;
                }
                ++i;
            }
            if (!isEmptyLine) {
                T dto = this.createDto(strs);
                this.performBasicCheck(dto, numLigne);
                if (this.errorMessage.size() != 0) {
                    return;
                }
                this.checkLineInSameFile(utilisateurs, dto, numLigne);
                if (this.errorMessage.size() != 0) {
                    return;
                }
                this.checkLineInDataBase(existing, dto, numLigne);
                if (this.errorMessage.size() != 0) {
                    return;
                }
                utilisateurs.add(dto);
            }
            ++numLigne;
        }
        this.saveInDataBase(utilisateurs);
    }

    private void checkEntete(HSSFRow row, int numCol, DataFormatter df) {
        int i = 0;
        while (i < numCol) {
            String str = this.getCell((Row)row, i, df);
            String entete = this.getEntete(i);
            if (entete != null && !StringUtils.equals(entete, str)) {
                this.errorMessage.add("Il y a une erreur sur la ligne 3 du fichier \u00e0 importer.");
                this.errorMessage.add("La colonne " + (i + 1) + " doit contenir l'ent\u00eate \"" + entete + "\"");
                this.errorMessage.add("Etes vous s\u00fbr d'avoir pris le bon fichier exemple ? ");
                return;
            }
            ++i;
        }
    }

    private void performBasicCheck(T dto, int numLigne) {
        String msg = this.checkBasic(dto);
        if (msg != null) {
            this.errorMessage.add("Il y a une erreur sur la ligne " + numLigne + " du fichier \u00e0 importer");
            this.errorMessage.add("Sur cette ligne :");
            this.errorMessage.add(msg);
            this.errorMessage.add("Voici d'autres informations sur la ligne " + numLigne + ":");
            this.dumpInfo(this.errorMessage, dto);
            this.errorMessage.add("");
            return;
        }
    }

    private void checkLineInSameFile(List<T> utilisateurs, T dto, int numLigne) {
        int numMax = utilisateurs.size();
        int i = 0;
        while (i < numMax) {
            TableItem utilisateurDTO = (TableItem)utilisateurs.get(i);
            String msg = this.checkDifferent(utilisateurDTO, dto);
            if (msg != null) {
                this.errorMessage.add("Il y a une incoh\u00e8rence entre la ligne " + (i + 2) + " et la ligne " + numLigne + " du fichier \u00e0 importer");
                this.errorMessage.add("Sur ces deux lignes :");
                this.errorMessage.add(msg);
                this.errorMessage.add("Voici d'autres informations sur la ligne " + (i + 2) + ":");
                this.dumpInfo(this.errorMessage, utilisateurDTO);
                this.errorMessage.add("");
                this.errorMessage.add("Voici d'autres informations sur la ligne " + numLigne + ":");
                this.dumpInfo(this.errorMessage, dto);
                this.errorMessage.add("");
                return;
            }
            ++i;
        }
    }

    private void checkLineInDataBase(List<T> existing, T dto, int numLigne) {
        if (this.allowUpdateOfExistingItem) {
            return;
        }
        for (TableItem utilisateurDTO : existing) {
            String msg = this.checkDifferent(utilisateurDTO, dto);
            if (msg == null) continue;
            this.errorMessage.add("Il y a une erreur sur la ligne " + numLigne + " du fichier \u00e0 importer");
            this.errorMessage.add("Sur cette ligne :");
            this.errorMessage.add(msg);
            this.errorMessage.add("Il existe d\u00e9j\u00e0 dans la base de donn\u00e9es un enregistrement avec ces informations :");
            this.dumpInfo(this.errorMessage, utilisateurDTO);
            this.errorMessage.add("");
            this.errorMessage.add("Voici d'autres informations sur la ligne " + numLigne + ":");
            this.dumpInfo(this.errorMessage, dto);
            this.errorMessage.add("");
            return;
        }
    }

    protected boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    protected String checkLength(String val, int minLength, int maxLength, String nomChamp) {
        int len;
        if (val == null) {
            val = "";
        }
        if ((len = val.length()) < minLength) {
            return "Le champ \"" + nomChamp + "\" est trop court. Il doit contenir au moins " + minLength + " caract\u00e8res";
        }
        if (len > maxLength) {
            return "Le champ \"" + nomChamp + "\"  est trop long. Il doit contenir au maximum " + maxLength + " caract\u00e8res";
        }
        return null;
    }

    private String getCell(Row row, int i, DataFormatter df) {
        if (row == null) {
            return null;
        }
        Cell cell = row.getCell(i);
        if (cell == null) {
            return null;
        }
        return df.formatCellValue(cell);
    }

    public List<String> checkThisElement(T dto) {
        String str = this.checkBasic(dto);
        if (str != null) {
            this.errorMessage.add(str);
            return this.errorMessage;
        }
        List<T> existing = this.getAllDataInDatabase();
        for (TableItem t : existing) {
            if (this.isSameId(t, dto) || (str = this.checkDifferent(t, dto)) == null) continue;
            this.errorMessage.add("Il existe un enregistrement dans la base de donn\u00e9es qui entre en conflit avec votre saisie");
            this.errorMessage.add("Raison :");
            this.errorMessage.add(str);
            this.errorMessage.add("Il existe d\u00e9j\u00e0 dans la base de donn\u00e9es un enregistrement avec ces informations :");
            this.dumpInfo(this.errorMessage, t);
            this.errorMessage.add("");
            return this.errorMessage;
        }
        return null;
    }

    private boolean isSameId(T t1, T t2) {
        T ti1 = t1;
        T ti2 = t2;
        return LongUtils.equals(ti1.getId(), ti2.getId());
    }

    public void checkThisElementAsException(T dto) throws OnSaveException {
        List<String> strs = this.checkThisElement(dto);
        if (strs != null) {
            throw new OnSaveException(strs);
        }
    }

    public List<String> unitTest() throws IOException {
        this.processFile();
        return this.errorMessage;
    }

    public void test(String filename) throws IOException {
        TestTools.init();
        this.baos = new ByteArrayOutputStream();
        this.baos.write(Files.readAllBytes(FileSystems.getDefault().getPath(filename, new String[0])));
        this.processFile();
        if (this.errorMessage.size() == 0) {
            System.out.println("Fichier import\u00e9 avec succ\u00e9s");
        } else {
            System.out.println("Erreur lors du chargement");
            for (String string : this.errorMessage) {
                System.out.println(string);
            }
        }
    }
}

