/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.listeadherents;

import com.vaadin.ui.Component;
import fr.amapj.common.CollectionUtils;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.service.services.edgenerator.excel.EGListeAdherent;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.parametres.paramecran.PEListeAdherentDTO;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.views.listeadherents.PopupCopyAllMail;
import java.util.List;

public class ListeAdherentsView
extends StandardListPart<UtilisateurDTO> {
    PEListeAdherentDTO p = new ParametresService().getPEListeAdherentDTO();

    public ListeAdherentsView() {
        super(UtilisateurDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des adh\u00e9rents";
    }

    @Override
    protected void drawButton() {
        if (this.p.canAccessEmail) {
            this.addButton("Envoyer un mail \u00e0 tous ...", ButtonType.ALWAYS, e -> this.handleSendMail());
        }
        this.addSearchField("Rechercher par le nom ou le pr\u00e9nom");
    }

    @Override
    protected void addExtraComponent() {
        this.addComponent((Component)LinkCreator.createLink(new EGListeAdherent(EGListeAdherent.Type.STD, this.p)));
    }

    @Override
    protected void drawTable() {
        this.addColumn("nom", "Nom");
        this.addColumn("prenom", "Pr\u00e9nom");
        if (this.p.canAccessEmail) {
            this.addColumn("email", "E mail");
        }
        if (this.p.canAccessTel1) {
            this.addColumn("numTel1", "Num\u00e9ro Tel 1");
        }
        if (this.p.canAccessTel2) {
            this.addColumn("numTel2", "Num\u00e9ro Tel 2");
        }
    }

    @Override
    protected List<UtilisateurDTO> getLines() {
        List<UtilisateurDTO> us = new UtilisateurService().getAllUtilisateurs(EtatUtilisateur.ACTIF);
        for (UtilisateurDTO u : us) {
            if (UtilisateurUtil.canSendMailTo(u.email)) continue;
            u.email = "Pas d'email";
        }
        return us;
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nom", "prenom"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom", "prenom"};
    }

    private CorePopup handleSendMail() {
        String mails = this.getAllEmails();
        return new PopupCopyAllMail(mails);
    }

    public String getAllEmails() {
        List<UtilisateurDTO> us = new UtilisateurService().getAllUtilisateurs(EtatUtilisateur.ACTIF);
        us.removeIf(u -> !UtilisateurUtil.canSendMailTo(u.email));
        return CollectionUtils.asString(us, ",", u -> u.email);
    }
}

