/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.login.passwordrecovery;

import fr.amapj.service.services.authentification.PasswordManager;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.genericmodel.StringItem;

public class PopupSaisieNewPasswordForPasswordRecovery
extends WizardFormPopup {
    private String resetPasswordSalt;
    private Long idUtilisateur;
    private StringItem password;

    public PopupSaisieNewPasswordForPasswordRecovery(String resetPasswordSalt) {
        this.popupTitle = "Changement de votre mot de passe";
        this.resetPasswordSalt = resetPasswordSalt;
        this.password = new StringItem();
        this.setModel(this.password);
    }

    @Override
    protected String checkInitialCondition() {
        this.idUtilisateur = new PasswordManager().findUserWithResetPassword(this.resetPasswordSalt);
        if (this.idUtilisateur == null) {
            return "Demande invalide ou trop ancienne";
        }
        return null;
    }

    @Override
    protected void configure() {
        this.add(() -> this.addSaisiePassword());
        this.add(() -> this.addResultat());
    }

    protected void addSaisiePassword() {
        this.addHtml("Vous avez demand\u00e9 \u00e0 changer de mot de passe suite \u00e0 l'oubli de celui ci. Merci de saisir votre nouveau mot de passe ci dessous.");
        this.addPasswordTextField("Votre nouveau mot de passe", "value");
    }

    private void addResultat() {
        boolean res = new PasswordManager().setUserPassword(this.idUtilisateur, this.password.value);
        String msg = res ? "Votre mot de passe a \u00e9t\u00e9 chang\u00e9 avec succ\u00e9s" : "Impossible de modifier votre mot de passe";
        this.addHtml(msg);
        this.setAllButtonsAsOK();
    }

    @Override
    protected void performSauvegarder() {
    }
}

